/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataGroupFileEditor
extends UserDataHolderBase
implements TextEditor {
    private final Project myProject;
    private final TestDataGroupVirtualFile myFile;
    private final TextEditor myBeforeEditor;
    private final TextEditor myAfterEditor;
    private WeakReference<Splitter> myComponent;

    public TestDataGroupFileEditor(Project project, TestDataGroupVirtualFile file) {
        this.myProject = project;
        this.myFile = file;
        this.myBeforeEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getBeforeFile());
        this.myAfterEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getAfterFile());
    }

    @NotNull
    public JComponent getComponent() {
        Splitter result = (Splitter)SoftReference.dereference(this.myComponent);
        if (result == null) {
            result = this.createComponent();
            this.myComponent = new WeakReference<Splitter>(result);
        }
        return result;
    }

    private Splitter createComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f, 0.1f, 0.9f);
        splitter.setFirstComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getBeforeFile().getName(), (FileEditor)this.myBeforeEditor));
        splitter.setSecondComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getAfterFile().getName(), (FileEditor)this.myAfterEditor));
        return splitter;
    }

    @NotNull
    public Editor getEditor() {
        return (SwingUtilities.isEventDispatchThread() && this.isBeforeEditorFocused() ? this.myBeforeEditor : this.myAfterEditor).getEditor();
    }

    private boolean isBeforeEditorFocused() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = focusManager.getFocusOwner();
        Splitter splitter = (Splitter)this.getComponent();
        return UIUtil.isDescendingFrom((Component)focusOwner, (Component)splitter.getFirstComponent());
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
    }

    private static JComponent wrapWithTitle(@NlsSafe String name, FileEditor beforeEditor) {
        JPanel panel2 = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(name, UIUtil.ComponentStyle.SMALL);
        label.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)2, (int)0));
        panel2.add("North", (Component)label);
        panel2.add("Center", beforeEditor.getComponent());
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return this.myFile.getName();
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return this.myBeforeEditor.isModified() || this.myAfterEditor.isModified();
    }

    public boolean isValid() {
        return this.myBeforeEditor.isValid() && this.myAfterEditor.isValid();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public void dispose() {
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myBeforeEditor);
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myAfterEditor);
    }
}

