/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface TestDataFile {
    public boolean exists();

    @Nullable
    public VirtualFile getVirtualFile();

    @NotNull
    @NlsSafe
    public String getPath();

    @NotNull
    @NlsSafe
    public String getName();

    public static class LazyResolved
    implements TestDataFile {
        private final String myPath;
        private VirtualFile myFile;
        private boolean myResolved;

        public LazyResolved(String path) {
            this.myPath = path;
        }

        private void resolve() {
            if (!this.myResolved) {
                this.myResolved = true;
                this.myFile = (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath));
            }
        }

        @Override
        public boolean exists() {
            this.resolve();
            return this.getVirtualFile() != null;
        }

        @Override
        public VirtualFile getVirtualFile() {
            this.resolve();
            return this.myFile;
        }

        @Override
        @NotNull
        public String getName() {
            return PathUtil.getFileName((String)this.getPath());
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myPath;
        }
    }

    public static class NonExisting
    implements TestDataFile {
        private final String myPath;

        public NonExisting(String path) {
            this.myPath = path;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return null;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myPath;
        }

        @Override
        @NotNull
        public String getName() {
            return PathUtil.getFileName((String)this.getPath());
        }
    }

    public static class Existing
    implements TestDataFile {
        @NotNull
        private final VirtualFile myFile;

        public Existing(@NotNull VirtualFile file) {
            this.myFile = file;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myFile.getPath();
        }

        @Override
        @NotNull
        public String getName() {
            return this.myFile.getName();
        }
    }
}

