/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.run.JUnitDevKitPatcher;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DevKitApplicationPatcher
extends RunConfigurationExtension {
    public <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters javaParameters, RunnerSettings runnerSettings) {
        ParametersList vmParametersList = javaParameters.getVMParametersList();
        Project project = configuration.getProject();
        if (PsiUtil.isIdeaProject(project) && !vmParametersList.getList().contains("--add-modules") && "com.intellij.idea.Main".equals(((ApplicationConfiguration)configuration).getMainClassName())) {
            String qualifiedName;
            Module module = ((JavaRunConfigurationModule)((ApplicationConfiguration)configuration).getConfigurationModule()).getModule();
            Sdk jdk = JavaParameters.getJdkToRunModule((Module)module, (boolean)true);
            if (jdk == null) {
                return;
            }
            if (!vmParametersList.hasProperty("java.system.class.loader") && JUnitDevKitPatcher.loaderValid(project, module, qualifiedName = "com.intellij.util.lang.PathClassLoader")) {
                vmParametersList.addProperty("java.system.class.loader", qualifiedName);
            }
            if (!vmParametersList.getList().contains("--add-opens")) {
                JUnitDevKitPatcher.appendAddOpensWhenNeeded(project, jdk, vmParametersList);
            }
        }
    }

    public boolean isApplicableFor(@NotNull RunConfigurationBase<?> configuration) {
        return configuration instanceof ApplicationConfiguration;
    }
}

