/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;

final class TestDataFilesReferencesContributor
extends PsiReferenceContributor {
    TestDataFilesReferencesContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().inCall((ElementPattern)UastPatterns.callExpression()), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public boolean acceptsTarget(@NotNull PsiElement target) {
                return target instanceof PsiFileSystemItem;
            }

            @NotNull
            public @NotNull PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression expression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                UCallExpression call = UastUtils.getUCallExpression((UElement)expression);
                if (call == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiParameter targetParameter = UastUtils.getParameterForArgument((UCallExpression)call, (UExpression)expression);
                if (targetParameter == null || !targetParameter.hasAnnotation("com.intellij.testFramework.TestDataFile")) {
                    return PsiReference.EMPTY_ARRAY;
                }
                String directory = TestDataFilesReferencesContributor.getTestDataDirectory(expression, call);
                if (directory == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReferenceSet fileReferenceSet = new FileReferenceSet((PsiElement)host);
                fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, ignore -> {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(directory);
                    return file == null ? null : Collections.singleton(host.getManager().findDirectory(file));
                });
                return fileReferenceSet.getAllReferences();
            }
        }, (double)0.0);
    }

    @Nullable
    private static String getTestDataDirectory(@NotNull UExpression expression, @NotNull UCallExpression methodCallExpression) {
        Object value = expression.evaluate();
        if (!(value instanceof String)) {
            return null;
        }
        String relativePath = (String)value;
        PsiMethod testMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)UastUtils.getParentOfType((UElement)methodCallExpression, UMethod.class), PsiMethod.class);
        if (testMethod == null) {
            return null;
        }
        List<String> filePaths = TestDataNavigationHandler.fastGetTestDataPathsByRelativePath(relativePath, testMethod);
        if (filePaths.size() != 1) {
            return null;
        }
        return StringUtil.trimEnd((String)filePaths.get(0), (String)relativePath);
    }
}

