/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.XmlBaseReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class PluginDescriptorXIncludeReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PluginDescriptorXIncludeReferenceContributor.getPattern(), (PsiReferenceProvider)new XIncludeReferenceProvider(), 100.0);
    }

    private static XmlAttributeValuePattern getPattern() {
        return (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"href"}).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("include")).withNamespace("http://www.w3.org/2001/XInclude"))).with((PatternCondition)new PatternCondition<XmlAttributeValue>("XInclude inside plugin.xml"){

            public boolean accepts(@NotNull XmlAttributeValue value, ProcessingContext context) {
                return PsiUtil.isPluginXmlPsiElement((PsiElement)value);
            }
        });
    }

    private static class XIncludeReferenceProvider
    extends XmlBaseReferenceProvider {
        XIncludeReferenceProvider() {
            super(true);
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            final PsiFile file = CompletionUtil.getOriginalOrSelf((PsiElement)element).getContainingFile();
            return new FileReferenceSet(element){

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return item -> DescriptorUtil.isPluginXml(item.getContainingFile()) && !file.equals(item);
                }
            }.getAllReferences();
        }
    }
}

