/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class PluginDescriptorXIncludeFileReferenceHelper
extends FileReferenceHelper {
    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        return !DumbService.isDumb((Project)project) && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE) && PsiUtil.isPluginProject(project) && DescriptorUtil.isPluginXml(PsiManager.getInstance((Project)project).findFile(file));
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        return PluginDescriptorXIncludeFileReferenceHelper.getRootsContainingPluginXmlFiles(project);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        return PluginDescriptorXIncludeFileReferenceHelper.getRootsContainingPluginXmlFiles(module.getProject());
    }

    private static Collection<PsiFileSystemItem> getRootsContainingPluginXmlFiles(@NotNull Project project) {
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Collection pluginXmlFilesInProductionScope = DomService.getInstance().getDomFileCandidates(IdeaPlugin.class, PluginRelatedLocatorsUtils.getCandidatesScope(project));
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            HashSet<VirtualFile> pluginXmlRoots = new HashSet<VirtualFile>();
            for (VirtualFile pluginXml : pluginXmlFilesInProductionScope) {
                VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(pluginXml);
                if (sourceRoot != null) {
                    pluginXmlRoots.add(sourceRoot);
                    continue;
                }
                VirtualFile classRoot = projectFileIndex.getClassRootForFile(pluginXml);
                ContainerUtil.addIfNotNull(pluginXmlRoots, (Object)classRoot);
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            List rootsPsiFileSystemItems = pluginXmlRoots.stream().map(virtualFile -> psiManager.findDirectory(virtualFile)).filter(Objects::nonNull).collect(Collectors.toList());
            return CachedValueProvider.Result.create(rootsPsiFileSystemItems, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }
}

