/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.references.PluginConfigReference;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

abstract class ExtensionPointReferenceBase
extends PsiReferenceBase<PsiElement>
implements PluginConfigReference {
    protected ExtensionPointReferenceBase(@NotNull PsiElement element) {
        super(element);
    }

    protected ExtensionPointReferenceBase(@NotNull PsiElement element, TextRange rangeInElement) {
        super(element, rangeInElement);
    }

    protected abstract String getExtensionPointFqn();

    @Nullable
    protected GenericAttributeValue<String> getNameElement(Extension extension) {
        return extension.getId();
    }

    @Nullable
    public PsiElement resolve() {
        String resolveId = this.getResolveValue();
        if (StringUtil.isEmptyOrSpaces((String)resolveId)) {
            return null;
        }
        CommonProcessors.FindFirstProcessor resolveProcessor = new CommonProcessors.FindFirstProcessor();
        this.processCandidates((Processor<? super Extension>)resolveProcessor, resolveId);
        Extension value = (Extension)resolveProcessor.getFoundValue();
        if (value == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)value, this.getNameElement(value));
        return target != null ? PomService.convertToPsi((PsiTarget)target) : value.getXmlElement();
    }

    @NotNull
    @NlsSafe
    protected String getResolveValue() {
        return this.getValue();
    }

    @Nullable
    protected static GenericAttributeValue<?> getAttribute(Extension extension, String attributeName) {
        DomAttributeChildDescription attributeDescription = extension.getGenericInfo().getAttributeChildDescription(attributeName);
        if (attributeDescription == null) {
            return null;
        }
        return attributeDescription.getDomAttributeValue((DomElement)extension);
    }

    @Nullable
    protected static String getAttributeValue(Extension extension, String attributeName) {
        GenericAttributeValue<?> attribute = ExtensionPointReferenceBase.getAttribute(extension, attributeName);
        return attribute == null ? null : attribute.getStringValue();
    }

    protected void processCandidates(Processor<? super Extension> processor) {
        this.processCandidates(processor, null);
    }

    private void processCandidates(Processor<? super Extension> processor, @Nullable String extensionPointId) {
        Project project = this.myElement.getProject();
        ExtensionPoint extensionPointDomElement = ExtensionPointIndex.findExtensionPoint(project, PluginRelatedLocatorsUtils.getCandidatesScope(project), this.getExtensionPointFqn());
        if (extensionPointDomElement == null) {
            return;
        }
        List<ExtensionCandidate> candidates = extensionPointId == null ? ExtensionLocatorKt.locateExtensionsByExtensionPoint(extensionPointDomElement) : ExtensionLocatorKt.locateExtensionsByExtensionPointAndId(extensionPointDomElement, extensionPointId, (Function1<? super Extension, String>)((Function1)extension -> {
            GenericAttributeValue<String> nameElement = this.getNameElement((Extension)extension);
            return nameElement != null ? nameElement.getStringValue() : null;
        })).findCandidates();
        DomManager manager = DomManager.getDomManager((Project)project);
        for (ExtensionCandidate candidate : candidates) {
            XmlTag element = (XmlTag)candidate.pointer.getElement();
            DomElement domElement = manager.getDomElement(element);
            if (!(domElement instanceof Extension) || processor.process((Object)((Extension)domElement))) continue;
            return;
        }
    }
}

