/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.DevKitIcons;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.util.DescriptorI18nUtil;

final class DevKitRelatedPropertiesProvider
extends DevkitRelatedLineMarkerProviderBase {
    DevKitRelatedPropertiesProvider() {
    }

    public String getName() {
        return DevKitBundle.message("line.marker.related.property.description", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        return DevKitIcons.Gutter.Properties;
    }

    protected void collectNavigationMarkers(@NotNull PsiElement leaf, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (!(leaf instanceof XmlToken)) {
            return;
        }
        if (leaf.getNode().getElementType() != XmlTokenType.XML_NAME) {
            return;
        }
        PsiElement prev = PsiTreeUtil.getPrevSiblingOfType((PsiElement)leaf, XmlToken.class);
        if (prev == null || prev.getNode().getElementType() != XmlTokenType.XML_START_TAG_START) {
            return;
        }
        if (!(leaf.textMatches((CharSequence)"action") || leaf.textMatches((CharSequence)"group") || leaf.textMatches((CharSequence)"override-text") || leaf.textMatches((CharSequence)"id"))) {
            return;
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)leaf);
        if (domElement instanceof ActionOrGroup) {
            ActionOrGroup actionOrGroup = (ActionOrGroup)domElement;
            DevKitRelatedPropertiesProvider.createLineMarker(leaf, result, domElement, actionOrGroup.getId());
        } else if (domElement instanceof OverrideText) {
            OverrideText overrideText = (OverrideText)domElement;
            DevKitRelatedPropertiesProvider.createLineMarker(leaf, result, domElement, overrideText.getPlace());
        } else if (domElement instanceof GenericDomValue) {
            DevKitRelatedPropertiesProvider.createLineMarker(leaf, result, domElement, (GenericDomValue)domElement);
        }
    }

    private static void createLineMarker(@NotNull PsiElement leaf, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, DomElement domElement, GenericDomValue<?> referenceElement) {
        if (!DomUtil.hasXml(referenceElement)) {
            return;
        }
        XmlElement valueXmlElement = DomUtil.getValueElement(referenceElement);
        if (valueXmlElement == null) {
            return;
        }
        PropertiesFile file = DescriptorI18nUtil.findBundlePropertiesFile(domElement);
        if (file == null) {
            return;
        }
        Query query = ReferencesSearch.search((PsiElement)valueXmlElement, (SearchScope)new LocalSearchScope((PsiElement)file.getContainingFile()));
        if (query.findFirst() == null) {
            return;
        }
        result.add(NavigationGutterIconBuilder.create((Icon)DevKitIcons.Gutter.Properties, e -> Collections.singletonList((PsiElement)e), e -> Collections.singletonList(new GotoRelatedItem((PsiElement)e))).setTargets(NotNullLazyValue.createValue(() -> ContainerUtil.map((Collection)query.findAll(), reference -> (Property)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), Property.class)))).setPopupTitle(DevKitBundle.message("line.marker.related.property.popup.title", new Object[0])).setTooltipText(DevKitBundle.message("line.marker.related.property.tooltip", new Object[0])).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(leaf));
    }
}

