/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.DevKitIcons;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ActionCandidate;
import org.jetbrains.idea.devkit.util.ComponentCandidate;
import org.jetbrains.idea.devkit.util.ListenerCandidate;
import org.jetbrains.idea.devkit.util.PointableCandidate;

final class LineMarkerInfoHelper {
    private static final NotNullFunction<PointableCandidate, Collection<? extends PsiElement>> CONVERTER = candidate -> ContainerUtil.createMaybeSingletonList((Object)((XmlTag)candidate.pointer.getElement()));

    private LineMarkerInfoHelper() {
    }

    @NotNull
    private static String getExtensionPointName(DomElement element) {
        if (!(element instanceof ExtensionPoint)) {
            return "?";
        }
        return ((ExtensionPoint)element).getEffectiveQualifiedName();
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.extension", new Object[0]), extension -> LineMarkerInfoHelper.getExtensionPointName(extension.getExtensionPoint()));
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionPointLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.extension.point", new Object[0]), extensionPoint -> LineMarkerInfoHelper.getExtensionPointName(extensionPoint));
    }

    static RelatedItemLineMarkerInfo<PsiElement> createListenerLineMarkerInfo(@NotNull List<? extends ListenerCandidate> targets, @NotNull PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.listener", new Object[0]), listener -> listener.getTopicClassName().getStringValue());
    }

    static RelatedItemLineMarkerInfo<PsiElement> createListenerTopicLineMarkerInfo(@NotNull List<? extends ListenerCandidate> targets, @NotNull PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.listener", new Object[0]), listener -> listener.getListenerClassName().getStringValue());
    }

    static RelatedItemLineMarkerInfo<?> createActionLineMarkerInfo(List<? extends ActionCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.action", new Object[0]), actionOrGroup -> actionOrGroup.getId().getStringValue());
    }

    static RelatedItemLineMarkerInfo<?> createActionGroupLineMarkerInfo(List<? extends ActionCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.action.group", new Object[0]), actionOrGroup -> actionOrGroup.getId().getStringValue());
    }

    static RelatedItemLineMarkerInfo<?> createComponentLineMarkerInfo(List<? extends ComponentCandidate> targets, PsiElement element) {
        return LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, DevKitBundle.message("gutter.related.navigation.choose.component", new Object[0]), component -> component.getImplementationClass().getStringValue());
    }

    @NotNull
    private static <T extends DomElement> RelatedItemLineMarkerInfo<PsiElement> createPluginLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element, @Nls(capitalization=Nls.Capitalization.Title) String popup, final NullableFunction<T, @NlsSafe String> namer) {
        return NavigationGutterIconBuilder.create((Icon)DevKitIcons.Gutter.Plugin, CONVERTER, target -> {
            final DomElement domElement = DomUtil.getDomElement((PsiElement)target.pointer.getElement());
            return Collections.singletonList(new DomGotoRelatedItem(domElement, "DevKit"){

                public String getCustomName() {
                    return LineMarkerInfoHelper.getDomElementName(domElement, namer);
                }

                @Nls
                @Nullable
                public String getCustomContainerName() {
                    PsiElement psiElement = this.getElement();
                    if (psiElement == null) {
                        return null;
                    }
                    return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(psiElement.getProject(), psiElement.getContainingFile().getVirtualFile());
                }
            });
        }).setTargets(targets).setPopupTitle(popup).setNamer(candidate -> {
            DomElement domElement = DomUtil.getDomElement((PsiElement)candidate.pointer.getElement());
            return LineMarkerInfoHelper.getDomElementName(domElement, namer);
        }).setCellRenderer(new Computable<PsiElementListCellRenderer<?>>(){

            public PsiElementListCellRenderer<?> compute() {
                return new PsiElementListCellRenderer<PsiElement>(){

                    protected Icon getIcon(PsiElement element) {
                        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
                        assert (domElement != null);
                        return (Icon)ObjectUtils.chooseNotNull((Object)domElement.getPresentation().getIcon(), (Object)element.getIcon(this.getIconFlags()));
                    }

                    public String getElementText(PsiElement element) {
                        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
                        return LineMarkerInfoHelper.getDomElementName(domElement, namer);
                    }

                    protected String getContainerText(PsiElement element, String name) {
                        return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(element.getProject(), element.getContainingFile().getVirtualFile());
                    }
                };
            }
        }).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(element);
    }

    @NlsSafe
    private static <T extends DomElement> String getDomElementName(T domElement, NullableFunction<T, @NlsSafe String> namer) {
        return StringUtil.defaultIfEmpty((String)((String)namer.fun(domElement)), (String)"?");
    }
}

