/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.annotations.NotNull;

public class IconsGeneratedSourcesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file.getName().endsWith("Icons.java")) {
            return (Boolean)ReadAction.compute(() -> {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile instanceof PsiJavaFile) {
                    for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
                        if (!aClass.isValid() || !aClass.hasModifierProperty("public")) continue;
                        PsiDocComment comment = aClass.getDocComment();
                        if (comment == null) {
                            return false;
                        }
                        String docText = comment.getText();
                        return docText.contains("NOTE THIS FILE IS AUTO-GENERATED") && docText.contains("DO NOT EDIT IT BY HAND");
                    }
                }
                return false;
            });
        }
        return false;
    }
}

