/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

final class DumpCleanHighlightingTestdataAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpCleanHighlightingTestdataAction.class);
    private final NullableLazyValue<Class<?>> myHighlightingDataClass = NullableLazyValue.lazyNullable(() -> {
        try {
            Path jar = Path.of(PathManager.getLibPath(), "testFramework.jar");
            if (Files.exists(jar, new LinkOption[0])) {
                URLClassLoader loader = new URLClassLoader(new URL[]{jar.toUri().toURL()}, ((Object)((Object)this)).getClass().getClassLoader());
                return Class.forName("com.intellij.testFramework.ExpectedHighlightingData", false, loader);
            }
            return Class.forName("com.intellij.testFramework.ExpectedHighlightingData");
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            LOG.error("'ExpectedHighlightingData' class not found, action disabled", (Throwable)e);
            return null;
        }
    });

    DumpCleanHighlightingTestdataAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null && this.myHighlightingDataClass.getValue() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null) {
            this.processFile(psiFile);
        } else {
            this.processDirectory(project);
        }
    }

    private void processFile(PsiFile psiFile) {
        Document document;
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            this.stripHighlightingData(document);
        }
    }

    private void processDirectory(Project project) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(DevKitBundle.message("action.DumpCleanTestData.file.chooser.title", new Object[0]));
        descriptor.setDescription(DevKitBundle.message("action.DumpCleanTestData.file.chooser.source.description", new Object[0]));
        VirtualFile dirToProcess = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (dirToProcess == null) {
            return;
        }
        descriptor.setDescription(DevKitBundle.message("action.DumpCleanTestData.file.chooser.destination.description", new Object[0]));
        VirtualFile destinationDir = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (destinationDir == null) {
            return;
        }
        if (dirToProcess.equals(destinationDir)) {
            Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("action.DumpCleanTestData.error.source.destination.must.differ", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        Path destination = destinationDir.toNioPath();
        for (VirtualFile file : dirToProcess.getChildren()) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) continue;
            this.stripHighlightingData(document);
            try {
                Files.writeString(destination.resolve(file.getName()), (CharSequence)document.getText(), file.getCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void stripHighlightingData(Document document) {
        Class klass = (Class)this.myHighlightingDataClass.getValue();
        if (klass != null) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                MethodHandle ctor = lookup.findConstructor(klass, MethodType.methodType(Void.TYPE, Document.class, Boolean.TYPE, Boolean.TYPE));
                Object instance = ctor.invoke(document, true, true);
                lookup.findVirtual(klass, "init", MethodType.methodType(Void.TYPE)).invoke(instance);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }
}

