/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class UseCoupleQuickFix
implements LocalQuickFix {
    private static final String COUPLE_FQN = "com.intellij.openapi.util.Couple";
    @IntentionName
    private final String myText;

    public UseCoupleQuickFix(@IntentionName String text2) {
        this.myText = text2;
    }

    @IntentionName
    @NotNull
    public String getName() {
        return this.myText;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.use.couple.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement newElement;
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        if (element instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiClassType type1 = (PsiClassType)typeElement.getType();
            PsiType[] parameters = type1.getParameters();
            if (parameters.length != 2) {
                return;
            }
            PsiTypeElement newType = factory.createTypeElementFromText("com.intellij.openapi.util.Couple<" + parameters[0].getCanonicalText() + ">", element.getContext());
            newElement = element.replace((PsiElement)newType);
        } else {
            PsiElement parent = element.getParent().getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            String text2 = "com.intellij.openapi.util.Couple.of" + methodCallExpression.getArgumentList().getText();
            PsiExpression expression = factory.createExpressionFromText(text2, element.getContext());
            newElement = parent.replace((PsiElement)expression);
        }
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }
}

