/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ClassExtensionPoint;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.quickfix.PluginDescriptorChooser;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;

public class RegisterExtensionFix
extends IntentionAndQuickFixAction {
    private final SmartPsiElementPointer<PsiClass> myExtensionClassPointer;
    private final Set<? extends ExtensionPointCandidate> myEPCandidates;
    @NonNls
    private static final Map<String, String> KEY_MAP = ContainerUtil.immutableMapBuilder().put((Object)KeyedFactoryEPBean.class.getName(), (Object)"key").put((Object)KeyedLazyInstanceEP.class.getName(), (Object)"key").put((Object)FileTypeExtensionPoint.class.getName(), (Object)"filetype").put((Object)LanguageExtensionPoint.class.getName(), (Object)"language").put((Object)ClassExtensionPoint.class.getName(), (Object)"forClass").build();

    public RegisterExtensionFix(PsiClass extensionClass, Set<? extends ExtensionPointCandidate> epCandidates) {
        this.myExtensionClassPointer = SmartPointerManager.createPointer((PsiElement)extensionClass);
        this.myEPCandidates = epCandidates;
    }

    @NotNull
    public String getText() {
        return DevKitBundle.message("register.extension.fix.name", new Object[0]);
    }

    @IntentionName
    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !DumbService.isDumb((Project)project);
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        PluginDescriptorChooser.show(project, editor, file, (Consumer<? super DomFileElement<IdeaPlugin>>)((Consumer)element -> this.doFix(editor, (DomFileElement<IdeaPlugin>)element)));
    }

    private void doFix(Editor editor, final DomFileElement<IdeaPlugin> element) {
        final PsiClass extensionClass = (PsiClass)this.myExtensionClassPointer.getElement();
        if (extensionClass == null || !extensionClass.isValid()) {
            return;
        }
        if (this.myEPCandidates.size() == 1) {
            RegisterExtensionFix.registerExtension(element, this.myEPCandidates.iterator().next(), extensionClass);
        } else {
            BaseListPopupStep<ExtensionPointCandidate> popupStep = new BaseListPopupStep<ExtensionPointCandidate>(DevKitBundle.message("register.extension.fix.popup.title", new Object[0]), new ArrayList<ExtensionPointCandidate>(this.myEPCandidates)){

                public PopupStep onChosen(ExtensionPointCandidate selectedValue, boolean finalChoice) {
                    RegisterExtensionFix.registerExtension((DomFileElement<IdeaPlugin>)element, selectedValue, extensionClass);
                    return FINAL_CHOICE;
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep).showInBestPositionFor(editor);
        }
    }

    private static void registerExtension(DomFileElement<IdeaPlugin> selectedValue, ExtensionPointCandidate candidate, PsiClass extensionClass) {
        PsiElement navTarget = (PsiElement)WriteCommandAction.writeCommandAction((Project)selectedValue.getFile().getProject(), (PsiFile[])new PsiFile[]{selectedValue.getFile()}).compute(() -> {
            Extensions extensions = PluginDescriptorChooser.findOrCreateExtensionsForEP((DomFileElement<? extends IdeaPlugin>)selectedValue, candidate.epName);
            Extension extension = extensions.addExtension(candidate.epName);
            XmlTag tag = extension.getXmlTag();
            XmlAttributeValue target = null;
            String keyAttrName = KEY_MAP.get(candidate.beanClassName);
            if (keyAttrName != null) {
                XmlAttribute attr = tag.setAttribute(keyAttrName, "");
                target = attr.getValueElement();
            }
            String qualifiedName = ClassUtil.getJVMClassName((PsiClass)extensionClass);
            if (candidate.attributeName != null) {
                tag.setAttribute(candidate.attributeName, qualifiedName);
            } else {
                XmlTag subTag = tag.createChildTag(candidate.tagName, null, qualifiedName, false);
                tag.addSubTag(subTag, false);
            }
            return target != null ? target : extension.getXmlTag();
        });
        PsiNavigateUtil.navigate((PsiElement)navTarget);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

