/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.quickfix.BaseFix;

public class CreateConstructorFix
extends BaseFix {
    public CreateConstructorFix(@NotNull PsiClass aClass, boolean isOnTheFly) {
        super((PsiElement)aClass, isOnTheFly);
    }

    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.registration.problems.quickfix.create.constructor", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor, boolean external) throws IncorrectOperationException {
        PsiElement element = this.myPointer.getElement();
        if (!(element instanceof PsiClass)) {
            return;
        }
        PsiClass clazz = (PsiClass)element;
        PsiMethod ctor = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory().createConstructor();
        PsiUtil.setModifierProperty((PsiModifierListOwner)ctor, (String)"public", (boolean)true);
        PsiMethod[] constructors = clazz.getConstructors();
        ctor = constructors.length > 0 ? (PsiMethod)clazz.addBefore((PsiElement)ctor, (PsiElement)constructors[0]) : (PsiMethod)clazz.add((PsiElement)ctor);
        if (this.myOnTheFly) {
            ctor.navigate(true);
        }
    }
}

