/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class ConvertToJBInsetsQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.use.dpi.aware.insets.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiNewExpression newExpression = (PsiNewExpression)descriptor.getPsiElement();
        PsiExpressionList list2 = newExpression.getArgumentList();
        if (list2 != null && list2.getExpressionCount() == 4) {
            String right;
            String bottom;
            String left;
            String top = list2.getExpressions()[0].getText();
            Object text2 = ConvertToJBInsetsQuickFix.isZero(top, left = list2.getExpressions()[1].getText(), bottom = list2.getExpressions()[2].getText(), right = list2.getExpressions()[3].getText()) ? "emptyInsets()" : (ConvertToJBInsetsQuickFix.isZero(left, bottom, right) ? "insetsTop(" + top + ")" : (ConvertToJBInsetsQuickFix.isZero(top, bottom, right) ? "insetsLeft(" + left + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, right) ? "insetsBottom(" + bottom + ")" : (ConvertToJBInsetsQuickFix.isZero(top, left, bottom) ? "insetsRight(" + right + ")" : (top.equals(left) && left.equals(bottom) && bottom.equals(right) ? "insets(" + top + ")" : (top.equals(bottom) && right.equals(left) ? String.format("insets(%s, %s)", top, left) : String.format("insets(%s, %s, %s, %s)", top, left, bottom, right)))))));
            text2 = JBUI.class.getName() + "." + (String)text2;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiExpression expression = factory.createExpressionFromText((String)text2, newExpression.getContext());
            PsiElement newElement = newExpression.replace((PsiElement)expression);
            PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            int offset = el.getTextOffset() + el.getText().length() - 2;
            Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
            if (editor != null) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private static boolean isZero(String ... args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if ("0".equals(arg)) continue;
            return false;
        }
        return true;
    }
}

