/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class ConvertToJBColorQuickFix
implements LocalQuickFix {
    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.use.jb.color.new.color.fix.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newJBColor = String.format("new %s(%s, new java.awt.Color())", JBColor.class.getName(), element.getText());
        PsiExpression expression = factory.createExpressionFromText(newJBColor, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
        int offset = el.getTextOffset() + el.getText().length() - 2;
        Editor editor = PsiEditorUtil.findEditor((PsiElement)el);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(offset);
        }
    }
}

