/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class ConvertToJBColorConstantQuickFix
implements LocalQuickFix {
    private final String myConstantName;

    public ConvertToJBColorConstantQuickFix(@NonNls String constantName) {
        this.myConstantName = constantName;
    }

    @IntentionName
    @NotNull
    public String getName() {
        return DevKitBundle.message("inspections.use.jb.color.fix", this.myConstantName);
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.use.jb.color.fix.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String jbColorConstant = String.format("%s.%s", JBColor.class.getName(), this.myConstantName);
        PsiExpression expression = factory.createExpressionFromText(jbColorConstant, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }
}

