/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class ConvertToGrayQuickFix
implements LocalQuickFix {
    private final int myNum;

    public ConvertToGrayQuickFix(int num) {
        this.myNum = num;
    }

    @IntentionName
    @NotNull
    public String getName() {
        return DevKitBundle.message("inspections.use.gray.convert", this.myNum);
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return DevKitBundle.message("inspections.use.gray.convert.family.name", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression expression = factory.createExpressionFromText("com.intellij.ui.Gray._" + this.myNum, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }
}

