/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.internal.UseEqualsInspectionBase;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;

public final class UsePrimitiveTypesEqualsInspection
extends UseEqualsInspectionBase {
    @Override
    @NotNull
    protected Class<?> getTargetClass() {
        return PsiPrimitiveType.class;
    }

    @Override
    protected boolean isExcluded(@NotNull UExpression operand) {
        return super.isExcluded(operand) || operand instanceof UReferenceExpression && UsePrimitiveTypesEqualsInspection.isNullPrimitivePsiType(((UReferenceExpression)operand).resolve());
    }

    private static boolean isNullPrimitivePsiType(@Nullable PsiElement psiElement) {
        return psiElement instanceof PsiField && UsePrimitiveTypesEqualsInspection.isNullPrimitivePsiType((PsiField)psiElement);
    }

    private static boolean isNullPrimitivePsiType(@NotNull PsiField psiField) {
        return "NULL".equals(psiField.getName()) && psiField.hasModifierProperty("static") && psiField.hasModifierProperty("final") && UsePrimitiveTypesEqualsInspection.isPsiType(psiField.getContainingClass());
    }

    private static boolean isPsiType(@Nullable PsiClass containingClass) {
        return containingClass != null && PsiType.class.getName().equals(containingClass.getQualifiedName());
    }
}

