/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public abstract class UseEqualsInspectionBase
extends DevKitUastInspectionBase {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        return super.isAllowed(holder) && JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(this.getTargetClass().getName(), holder.getFile().getResolveScope()) != null;
    }

    @Override
    @NotNull
    protected final PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression binaryExpression) {
                PsiElement sourcePsi;
                PsiElement psiElement = sourcePsi = UseEqualsInspectionBase.this.isEqualityExpression(binaryExpression) ? binaryExpression.getSourcePsi() : null;
                if (sourcePsi != null) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.equals.description", UseEqualsInspectionBase.this.getTargetClass().getSimpleName()), new LocalQuickFix[0]);
                }
                return true;
            }
        }, (Class[])new Class[]{UBinaryExpression.class});
    }

    @NotNull
    protected abstract Class<?> getTargetClass();

    protected boolean isExcluded(@NotNull UExpression operand) {
        return operand instanceof ULiteralExpression || operand instanceof UThisExpression;
    }

    private boolean hasTargetType(@NotNull UExpression operand) {
        return operand.getSourcePsi() != null && InheritanceUtil.isInheritor((PsiType)operand.getExpressionType(), (String)this.getTargetClass().getName());
    }

    private boolean isEqualityExpression(@NotNull UBinaryExpression binaryExpression) {
        UastBinaryOperator operator = binaryExpression.getOperator();
        if (operator != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return false;
        }
        UExpression leftOperand = binaryExpression.getLeftOperand();
        if (this.isExcluded(leftOperand)) {
            return false;
        }
        UExpression rightOperand = binaryExpression.getRightOperand();
        if (this.isExcluded(rightOperand)) {
            return false;
        }
        return this.hasTargetType(leftOperand) || this.hasTargetType(rightOperand);
    }
}

