/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.ConvertToJBBorderQuickFix;

public class UseDPIAwareEmptyBorderInspection
extends DevKitInspectionBase {
    private static final CallMatcher JBUI_BORDERS_EMPTY = CallMatcher.staticCall((String)"com.intellij.util.ui.JBUI.Borders", (String[])new String[]{"empty"});

    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                ProblemDescriptor descriptor = UseDPIAwareEmptyBorderInspection.checkMethodCallCanBeSimplified(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
                super.visitMethodCallExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                ProblemDescriptor descriptor = UseDPIAwareEmptyBorderInspection.checkNewExpression(expression, holder.getManager(), isOnTheFly);
                if (descriptor != null) {
                    holder.registerProblem(descriptor);
                }
                super.visitNewExpression(expression);
            }
        };
    }

    private static ProblemDescriptor checkMethodCallCanBeSimplified(PsiMethodCallExpression expression, InspectionManager manager, boolean isOnTheFly) {
        if (!JBUI_BORDERS_EMPTY.test(expression)) {
            return null;
        }
        if (ConvertToJBBorderQuickFix.canSimplify(expression)) {
            return manager.createProblemDescriptor((PsiElement)expression, DevKitBundle.message("inspections.use.dpi.aware.empty.border.simplify", new Object[0]), (LocalQuickFix)new ConvertToJBBorderQuickFix(){

                @Override
                @IntentionFamilyName
                @NotNull
                public String getFamilyName() {
                    return DevKitBundle.message("inspections.use.dpi.aware.empty.border.family.name", new Object[0]);
                }
            }, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        }
        return null;
    }

    @Nullable
    private static ProblemDescriptor checkNewExpression(PsiNewExpression expression, InspectionManager manager, boolean isOnTheFly) {
        JavaPsiFacade facade;
        PsiClass jbuiClass;
        Project project = manager.getProject();
        PsiType type2 = expression.getType();
        PsiExpressionList arguments = expression.getArgumentList();
        if (type2 != null && arguments != null && type2.equalsToText("javax.swing.border.EmptyBorder") && (jbuiClass = (facade = JavaPsiFacade.getInstance((Project)project)).findClass(JBUI.class.getName(), GlobalSearchScope.allScope((Project)project))) != null && facade.getResolveHelper().isAccessible((PsiMember)jbuiClass, (PsiElement)expression, jbuiClass)) {
            PsiType parentType;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiNewExpression && ((parentType = ((PsiNewExpression)parent.getParent()).getType()) == null || JBEmptyBorder.class.getName().equals(parentType.getCanonicalText()))) {
                return null;
            }
            if (arguments.getExpressionCount() == 4) {
                return manager.createProblemDescriptor((PsiElement)expression, DevKitBundle.message("inspections.use.dpi.aware.empty.border.replace", new Object[0]), (LocalQuickFix)new ConvertToJBBorderQuickFix(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            }
        }
        return null;
    }
}

