/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class UnsafeReturnStatementVisitorInspection
extends DevKitInspectionBase {
    @NonNls
    private static final String BASE_WALKING_VISITOR_NAME = JavaRecursiveElementWalkingVisitor.class.getName();
    @NonNls
    private static final String BASE_VISITOR_NAME = JavaRecursiveElementVisitor.class.getName();
    @NonNls
    private static final String EMPTY_LAMBDA = "public void visitLambdaExpression(PsiLambdaExpression expression) {}";
    @NonNls
    private static final String EMPTY_CLASS = "public void visitClass(PsiClass aClass) {}";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                if ((InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_WALKING_VISITOR_NAME) || InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_VISITOR_NAME)) && UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitReturnStatement", PsiReturnStatement.class.getName())) {
                    boolean skipLambdaFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitLambdaExpression", PsiLambdaExpression.class.getName());
                    boolean skipClassFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitClass", PsiClass.class.getName());
                    if (!skipClassFound || !skipLambdaFound) {
                        String[] methods;
                        String name;
                        if (!skipLambdaFound ^ !skipClassFound) {
                            if (!skipLambdaFound) {
                                name = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression", new Object[0]);
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA};
                            } else {
                                name = DevKitBundle.message("inspections.unsafe.return.insert.visit.class.method", new Object[0]);
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                            }
                        } else {
                            name = DevKitBundle.message("inspections.unsafe.return.insert.visit.lambda.expression.and.class.methods", new Object[0]);
                            methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA, UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                        }
                        holder.registerProblem((PsiElement)aClass, HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass).shiftRight(-aClass.getTextRange().getStartOffset()), DevKitBundle.message("inspections.unsafe.return.message", new Object[0]), new LocalQuickFix[]{new MySkipVisitFix(name, methods)});
                    }
                }
            }
        };
    }

    private static boolean findVisitMethod(PsiClass aClass, String visitMethodName, String argumentType) {
        PsiMethod[] visitReturnStatements;
        for (PsiMethod method : visitReturnStatements = aClass.findMethodsByName(visitMethodName, false)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !parameters[0].getType().equalsToText(argumentType)) continue;
            return true;
        }
        return false;
    }

    private static class MySkipVisitFix
    implements LocalQuickFix {
        @IntentionName
        private final String myName;
        private final String[] myMethods;

        MySkipVisitFix(@IntentionName String name, String[] methods) {
            this.myName = name;
            this.myMethods = methods;
        }

        @IntentionName
        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.unsafe.return.insert.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiClass) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiClass aClass = (PsiClass)element;
                for (String methodText : this.myMethods) {
                    PsiMethod method = factory.createMethodFromText(methodText, element);
                    PsiMethod overridden = aClass.findMethodBySignature(method, true);
                    if (overridden != null) {
                        OverrideImplementUtil.annotateOnOverrideImplement((PsiMethod)method, (PsiClass)aClass, (PsiMethod)overridden);
                    }
                    aClass.add((PsiElement)method);
                }
            }
        }
    }
}

