/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u000bH\u0003\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"localQuickFixFqn", "", "kotlin.jvm.PlatformType", "projectComponentFqn", "findEpCandidates", "", "Lcom/intellij/psi/xml/XmlTag;", "project", "Lcom/intellij/openapi/project/Project;", "className", "isProjectFieldAllowed", "", "field", "Lcom/intellij/lang/jvm/JvmField;", "clazz", "Lcom/intellij/lang/jvm/JvmClass;", "targets", "message", "what", "quickFix", "intellij.devkit.core"})
public final class StatefulEpInspectionKt {
    private static final String localQuickFixFqn = LocalQuickFix.class.getCanonicalName();
    private static final String projectComponentFqn = ProjectComponent.class.getCanonicalName();

    private static final Collection<XmlTag> findEpCandidates(Project project, String className) {
        List result = Collections.synchronizedList((List)new SmartList());
        boolean $i$f$processExtensionsByClassName = false;
        ExtensionLocatorKt.processExtensionDeclarations$default(className, project, false, (Function2)new Function2<Extension, XmlTag, Boolean>(className, result){
            final /* synthetic */ String $className$inlined;
            final /* synthetic */ List $result$inlined;
            {
                this.$className$inlined = string;
                this.$result$inlined = list2;
                super(2);
            }

            public final boolean invoke(@NotNull Extension extension, @NotNull XmlTag tag) {
                boolean bl;
                ExtensionPoint extensionPoint = extension.getExtensionPoint();
                if (extensionPoint != null) {
                    ExtensionPoint extensionPoint2;
                    ExtensionPoint it = extensionPoint2 = extensionPoint;
                    boolean bl2 = false;
                    ExtensionPoint extensionPoint3 = it;
                    XmlTag tag2 = tag;
                    boolean bl3 = false;
                    String string = tag2.getAttributeValue("forClass");
                    if (string == null || !StringsKt.contains$default((CharSequence)string, (CharSequence)this.$className$inlined, (boolean)false, (int)2, null)) {
                        this.$result$inlined.add(tag2);
                    }
                    bl = true;
                } else {
                    bl = true;
                }
                return bl;
            }
        }, 4, null);
        return result;
    }

    private static final boolean isProjectFieldAllowed(JvmField field, JvmClass clazz, Collection<? extends XmlTag> targets) {
        boolean bl;
        block4: {
            if (field.hasModifier(JvmModifier.FINAL)) {
                return true;
            }
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XmlTag candidate = (XmlTag)element$iv;
                    boolean bl2 = false;
                    String name = candidate.getName();
                    if (!(Intrinsics.areEqual((Object)"projectService", (Object)name) || Intrinsics.areEqual((Object)"projectConfigurable", (Object)name))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl || JvmInheritanceUtil.isInheritor((JvmClass)clazz, (String)projectComponentFqn);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static final String message(String what, boolean quickFix) {
        if (quickFix) {
            return DevKitBundle.message("inspections.stateful.extension.point.do.not.use.in.quick.fix", what);
        }
        return DevKitBundle.message("inspections.stateful.extension.point.do.not.use.in.extension", what);
    }

    public static final /* synthetic */ String access$getLocalQuickFixFqn$p() {
        return localQuickFixFqn;
    }

    public static final /* synthetic */ Collection access$findEpCandidates(Project project, String className) {
        return StatefulEpInspectionKt.findEpCandidates(project, className);
    }

    public static final /* synthetic */ String access$message(String what, boolean quickFix) {
        return StatefulEpInspectionKt.message(what, quickFix);
    }

    public static final /* synthetic */ boolean access$isProjectFieldAllowed(JvmField field, JvmClass clazz, Collection targets) {
        return StatefulEpInspectionKt.isProjectFieldAllowed(field, clazz, targets);
    }
}

