/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.ExtensionPoints;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MoveToPackageFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xml.util.IncludedXmlTag;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Anchor;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.DependencyDescriptor;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.Helpset;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Listeners;
import org.jetbrains.idea.devkit.dom.ProductDescriptor;
import org.jetbrains.idea.devkit.dom.Synonym;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.AddWithTagFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PluginPlatformInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class PluginXmlDomInspection
extends DevKitPluginXmlInspectionBase {
    private static final Logger LOG = Logger.getInstance(PluginXmlDomInspection.class);
    @NonNls
    private static final String PLUGIN_ICON_SVG_FILENAME = "pluginIcon.svg";
    @NonNls
    public static final String DEPENDENCIES_DOC_URL = "https://plugins.jetbrains.com/docs/intellij/plugin-dependencies.html?from=DevkitPluginXmlInspection";
    public List<String> myRegistrationCheckIgnoreClassList = new ExternalizableStringSet(new String[0]);
    @XCollection
    public List<PluginModuleSet> PLUGINS_MODULES = new ArrayList<PluginModuleSet>();
    private final ClearableLazyValue<Map<String, PluginModuleSet>> myPluginModuleSetByModuleName = ClearableLazyValue.createAtomic(() -> {
        HashMap<String, PluginModuleSet> result = new HashMap<String, PluginModuleSet>();
        for (PluginModuleSet modulesSet : this.PLUGINS_MODULES) {
            for (String module : modulesSet.modules) {
                result.put(module, modulesSet);
            }
        }
        return result;
    });
    private static final int LISTENERS_PLATFORM_VERSION = 193;
    private static final int LISTENERS_OS_ATTRIBUTE_PLATFORM_VERSION = 201;
    private static final Pattern BASE_LINE_EXTRACTOR = Pattern.compile("(?:\\p{javaLetter}+-)?(\\d+)(?:\\..*)?");
    private static final int FIRST_BRANCH_SUPPORTING_STAR = 131;

    @NotNull
    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(this.myRegistrationCheckIgnoreClassList, ""));
        JPanel panel2 = UiUtils.createAddRemoveTreeClassChooserPanel((ListTable)table, (String)DevKitBundle.message("inspections.plugin.xml.add.ignored.class.title", new Object[0]), (String[])new String[0]);
        PanelGridBuilder grid = UI.PanelFactory.grid();
        grid.resize().add((PanelBuilder)UI.PanelFactory.panel((JComponent)panel2).withLabel(DevKitBundle.message("inspections.plugin.xml.ignore.classes.title", new Object[0])).moveLabelOnTop().resizeY(true));
        if (ApplicationManager.getApplication().isInternal()) {
            final JBTextArea component = new JBTextArea(5, 80);
            component.setText(this.PLUGINS_MODULES.stream().map(it -> String.join((CharSequence)",", it.modules)).collect(Collectors.joining("\n")));
            component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    PluginXmlDomInspection.this.PLUGINS_MODULES.clear();
                    for (String line : StringUtil.splitByLines((String)component.getText())) {
                        PluginModuleSet set = new PluginModuleSet();
                        set.modules = new LinkedHashSet<String>(StringUtil.split((String)line, (String)","));
                        PluginXmlDomInspection.this.PLUGINS_MODULES.add(set);
                    }
                    PluginXmlDomInspection.this.myPluginModuleSetByModuleName.drop();
                }
            });
            ComponentPanelBuilder pluginModulesPanel = UI.PanelFactory.panel((JComponent)new JBScrollPane((java.awt.Component)component)).withLabel(DevKitBundle.message("inspections.plugin.xml.plugin.modules.label", new Object[0])).moveLabelOnTop().withComment(DevKitBundle.message("inspections.plugin.xml.plugin.modules.description", new Object[0])).resizeY(true);
            grid.add((PanelBuilder)pluginModulesPanel);
        }
        return grid.createPanel();
    }

    public void readSettings(@NotNull Element node) {
        super.readSettings(node);
        this.myPluginModuleSetByModuleName.drop();
    }

    @NotNull
    public String getShortName() {
        return "PluginXmlValidity";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue domValue;
        super.checkDomElement(element, holder, helper);
        ComponentModuleRegistrationChecker componentModuleRegistrationChecker = new ComponentModuleRegistrationChecker(this.myPluginModuleSetByModuleName, this.myRegistrationCheckIgnoreClassList, holder);
        if (element instanceof IdeaPlugin) {
            Module module = element.getModule();
            if (module != null) {
                PluginXmlDomInspection.annotateIdeaPlugin((IdeaPlugin)element, holder, module);
                PluginXmlDomInspection.checkJetBrainsPlugin((IdeaPlugin)element, holder, module);
                PluginXmlDomInspection.checkPluginIcon((IdeaPlugin)element, holder, module);
            }
        } else if (element instanceof Extension) {
            PluginXmlDomInspection.annotateExtension((Extension)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof ExtensionPoint) {
            PluginXmlDomInspection.annotateExtensionPoint((ExtensionPoint)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof Vendor) {
            PluginXmlDomInspection.annotateVendor((Vendor)element, holder);
        } else if (element instanceof ProductDescriptor) {
            PluginXmlDomInspection.annotateProductDescriptor((ProductDescriptor)element, holder);
        } else if (element instanceof IdeaVersion) {
            PluginXmlDomInspection.annotateIdeaVersion((IdeaVersion)element, holder);
        } else if (element instanceof Dependency) {
            PluginXmlDomInspection.annotateDependency((Dependency)element, holder);
        } else if (element instanceof DependencyDescriptor) {
            PluginXmlDomInspection.annotateDependencyDescriptor((DependencyDescriptor)element, holder);
        } else if (element instanceof ContentDescriptor) {
            PluginXmlDomInspection.annotateContentDescriptor((ContentDescriptor)element, holder);
        } else if (element instanceof Extensions) {
            PluginXmlDomInspection.annotateExtensions((Extensions)element, holder);
        } else if (element instanceof Extensions.UnresolvedExtension) {
            PluginXmlDomInspection.annotateUnresolvedExtension((Extensions.UnresolvedExtension)element, holder);
        } else if (element instanceof AddToGroup) {
            PluginXmlDomInspection.annotateAddToGroup((AddToGroup)element, holder);
        } else if (element instanceof Action) {
            PluginXmlDomInspection.annotateAction((Action)element, holder, componentModuleRegistrationChecker);
        } else if (element instanceof Synonym) {
            PluginXmlDomInspection.annotateSynonym((Synonym)element, holder);
        } else if (element instanceof Group) {
            PluginXmlDomInspection.annotateGroup((Group)element, holder);
        } else if (element instanceof Component) {
            PluginXmlDomInspection.annotateComponent((Component)element, holder, componentModuleRegistrationChecker);
            if (element instanceof Component.Project) {
                PluginXmlDomInspection.annotateProjectComponent((Component.Project)element, holder);
            }
        } else if (element instanceof Helpset) {
            PluginXmlDomInspection.highlightRedundant(element, DevKitBundle.message("inspections.plugin.xml.deprecated.helpset", new Object[0]), holder);
        } else if (element instanceof Listeners) {
            PluginXmlDomInspection.annotateListeners((Listeners)element, holder);
        } else if (element instanceof Listeners.Listener) {
            PluginXmlDomInspection.annotateListener((Listeners.Listener)element, holder);
        }
        if (element instanceof GenericDomValue && (domValue = (GenericDomValue)element).getConverter() instanceof PluginPsiClassConverter) {
            PluginXmlDomInspection.annotatePsiClassValue(domValue, holder);
        }
    }

    private static void annotateDependencyDescriptor(DependencyDescriptor descriptor, DomElementAnnotationHolder holder) {
        if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains(descriptor)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(descriptor, holder);
            return;
        }
        if (descriptor.getModuleEntry().isEmpty() && descriptor.getPlugin().isEmpty()) {
            holder.createProblem((DomElement)descriptor, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.descriptor.at.least.one.dependency", new Object[0]));
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)descriptor.getParentOfType(IdeaPlugin.class, false);
        assert (ideaPlugin != null);
        for (Dependency dependency : ideaPlugin.getDepends()) {
            if (dependency.getOptional().getValue() == Boolean.TRUE) continue;
            holder.createProblem((DomElement)dependency, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.descriptor.cannot.use.depends", new Object[0])).highlightWholeElement();
        }
    }

    private static void annotateContentDescriptor(ContentDescriptor descriptor, DomElementAnnotationHolder holder) {
        if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains(descriptor)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(descriptor, holder);
            return;
        }
        if (descriptor.getModuleEntry().isEmpty()) {
            holder.createProblem((DomElement)descriptor, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.module.descriptor.at.least.one.dependency", new Object[0]));
        }
    }

    private static boolean isIdeaProjectOrJetBrains(DomElement element) {
        Module module = element.getModule();
        if (module == null) {
            return true;
        }
        if (PsiUtil.isIdeaProject(module.getProject())) {
            return true;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)element.getParentOfType(IdeaPlugin.class, false);
        assert (ideaPlugin != null);
        return PluginManagerCore.isDevelopedByJetBrains((String)ideaPlugin.getVendor().getValue());
    }

    private static void annotatePsiClassValue(GenericDomValue domValue, DomElementAnnotationHolder holder) {
        Object value = domValue.getValue();
        if (value instanceof PsiClass) {
            Module module;
            PsiClass psiClass = (PsiClass)value;
            if (psiClass.getContainingClass() != null && !StringUtil.containsChar((String)StringUtil.notNullize((String)domValue.getRawText()), (char)'$')) {
                holder.createProblem((DomElement)domValue, DevKitBundle.message("inspections.plugin.xml.inner.class.must.be.separated.with.dollar", new Object[0]), new LocalQuickFix[0]);
            }
            if ((module = domValue.getModule()) == null) {
                return;
            }
            if (!PluginXmlDomInspection.isIdeaProjectOrJetBrains((DomElement)domValue)) {
                return;
            }
            IdeaPlugin ideaPlugin = (IdeaPlugin)domValue.getParentOfType(IdeaPlugin.class, true);
            assert (ideaPlugin != null);
            String pluginPackage = ideaPlugin.getPackage().getStringValue();
            if (pluginPackage == null) {
                return;
            }
            String psiClassFqn = psiClass.getQualifiedName();
            assert (psiClassFqn != null);
            if (!StringUtil.startsWith((CharSequence)psiClassFqn, (CharSequence)(pluginPackage + ".")) && module == ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) {
                holder.createProblem((DomElement)domValue, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.dependency.class.located.in.wrong.package", psiClassFqn, pluginPackage), new LocalQuickFix[]{new MoveToPackageFix(psiClass.getContainingFile(), pluginPackage)});
            }
        }
    }

    private static boolean isUnderProductionSources(DomElement domElement, @NotNull Module module) {
        VirtualFile virtualFile = DomUtil.getFile((DomElement)domElement).getVirtualFile();
        return virtualFile != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION);
    }

    private static void annotateListener(Listeners.Listener listener, DomElementAnnotationHolder holder) {
        PsiClass listenerClass = (PsiClass)listener.getListenerClassName().getValue();
        PsiClass topicClass = (PsiClass)listener.getTopicClassName().getValue();
        if (listenerClass == null || topicClass == null) {
            return;
        }
        if (!listenerClass.isInheritor(topicClass, true)) {
            holder.createProblem(listener.getListenerClassName(), DevKitBundle.message("inspections.plugin.xml.listener.does.not.inherit", listener.getListenerClassName().getStringValue(), listener.getTopicClassName().getStringValue()), new LocalQuickFix[0]);
        }
    }

    private static void annotateListeners(Listeners listeners, DomElementAnnotationHolder holder) {
        boolean canHaveOsAttribute;
        Module module = listeners.getModule();
        if (module == null || PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        PluginPlatformInfo platformInfo = PluginPlatformInfo.forDomElement(listeners);
        PluginPlatformInfo.PlatformResolveStatus resolveStatus = platformInfo.getResolveStatus();
        if (resolveStatus == PluginPlatformInfo.PlatformResolveStatus.DEVKIT_NO_MAIN) {
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.could.not.locate.main.descriptor", new Object[0]), null, new LocalQuickFix[0]).highlightWholeElement();
            return;
        }
        if (resolveStatus == PluginPlatformInfo.PlatformResolveStatus.DEVKIT_NO_SINCE_BUILD) {
            boolean noSinceBuildXml = !DomUtil.hasXml(platformInfo.getMainIdeaPlugin().getIdeaVersion().getSinceBuild());
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.must.be.specified", new Object[0]), null, new LocalQuickFix[]{noSinceBuildXml ? new AddDomElementQuickFix((DomElement)platformInfo.getMainIdeaPlugin().getIdeaVersion()) : null}).highlightWholeElement();
            return;
        }
        BuildNumber buildNumber = platformInfo.getSinceBuildNumber();
        if (buildNumber == null) {
            holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.could.not.determine.platform.version", new Object[0]), null, new LocalQuickFix[0]).highlightWholeElement();
            return;
        }
        int baselineVersion = buildNumber.getBaselineVersion();
        boolean bl = canHaveOsAttribute = baselineVersion >= 201;
        if (!canHaveOsAttribute) {
            for (Listeners.Listener listener : listeners.getListeners()) {
                if (!DomUtil.hasXml(listener.getOs())) continue;
                holder.createProblem(listener.getOs(), ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.listeners.os.attribute", 201, baselineVersion), null, new LocalQuickFix[0]).highlightWholeElement();
            }
        }
        if (baselineVersion >= 193) {
            return;
        }
        holder.createProblem((DomElement)listeners, ProblemHighlightType.ERROR, DevKitBundle.message("inspections.plugin.xml.since.build.listeners.not.available", 193, baselineVersion), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void annotateDependency(Dependency dependency, DomElementAnnotationHolder holder) {
        GenericAttributeValue<Boolean> optional = dependency.getOptional();
        if (optional.getValue() == Boolean.FALSE) {
            PluginXmlDomInspection.highlightRedundant(optional, DevKitBundle.message("inspections.plugin.xml.dependency.superfluous.optional", new Object[0]), ProblemHighlightType.WARNING, holder);
        } else if (optional.getValue() == Boolean.TRUE && !DomUtil.hasXml(dependency.getConfigFile())) {
            holder.createProblem((DomElement)dependency, DevKitBundle.message("inspections.plugin.xml.dependency.specify.config.file", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(dependency.getConfigFile())}).highlightWholeElement();
        }
    }

    private static void annotateIdeaPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, @NotNull Module module) {
        boolean isNotIdeaProject;
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaPlugin.getIdeaPluginVersion(), holder);
        if (DomUtil.hasXml(ideaPlugin.getUseIdeaClassloader())) {
            PluginXmlDomInspection.highlightDeprecated(ideaPlugin.getUseIdeaClassloader(), DevKitBundle.message("inspections.plugin.xml.deprecated", new Object[0]), holder, true, true);
        }
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getUrl(), 255, holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getId(), 255, holder);
        PluginXmlDomInspection.checkTemplateText(ideaPlugin.getName(), "Plugin display name here", holder);
        PluginXmlDomInspection.checkTemplateTextContainsWord(ideaPlugin.getName(), holder, "plugin", "IntelliJ", "JetBrains");
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getName(), 255, holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getDescription(), 65535, holder);
        PluginXmlDomInspection.checkHasRealText(ideaPlugin.getDescription(), 40, holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getDescription(), "Enter short description for your plugin here.", holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getDescription(), "most HTML tags may be used", holder);
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getChangeNotes(), 65535, holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getChangeNotes(), "Add change notes here", holder);
        PluginXmlDomInspection.checkTemplateTextContains(ideaPlugin.getChangeNotes(), "most HTML tags may be used", holder);
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        MultiMap dependencies = MultiMap.create();
        ideaPlugin.getDepends().forEach(dependency -> {
            if (DomUtil.hasXml(dependency.getConfigFile())) {
                dependencies.putValue((Object)dependency.getConfigFile().getStringValue(), dependency);
            }
        });
        for (Map.Entry entry : dependencies.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (Dependency dependency2 : (Collection)entry.getValue()) {
                if (dependency2.getXmlTag() instanceof IncludedXmlTag) continue;
                PluginXmlDomInspection.highlightRedundant((DomElement)dependency2, DevKitBundle.message("inspections.plugin.xml.duplicated.dependency", entry.getKey()), ProblemHighlightType.ERROR, holder);
            }
        }
        boolean bl = isNotIdeaProject = !PsiUtil.isIdeaProject(module.getProject());
        if (isNotIdeaProject && !DomUtil.hasXml(ideaPlugin.getVersion()) && PluginModuleType.isOfType(module)) {
            holder.createProblem((DomElement)ideaPlugin, DevKitBundle.message("inspections.plugin.xml.version.must.be.specified", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.add.version.tag", new Object[0]), ideaPlugin.getVersion(), "")});
        }
        PluginXmlDomInspection.checkMaxLength(ideaPlugin.getVersion(), 64, holder);
        if (isNotIdeaProject && !DomUtil.hasXml((DomElement)ideaPlugin.getVendor())) {
            holder.createProblem((DomElement)ideaPlugin, DevKitBundle.message("inspections.plugin.xml.vendor.must.be.specified", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.add.vendor.tag", new Object[0]), ideaPlugin.getVendor(), "")});
        }
        if (DomUtil.hasXml(ideaPlugin.getPackage()) && !PluginXmlDomInspection.isIdeaProjectOrJetBrains(ideaPlugin)) {
            PluginXmlDomInspection.highlightJetbrainsOnly(ideaPlugin.getPackage(), holder);
        }
    }

    private static void checkJetBrainsPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, @NotNull Module module) {
        String url;
        if (!PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        if (DomUtil.hasXml(ideaPlugin.getUrl()) && "https://www.jetbrains.com/idea".equals(url = ideaPlugin.getUrl().getStringValue())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getUrl(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.generic.plugin.url", new Object[0]), holder);
        }
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        @NonNls String id = ideaPlugin.getId().getStringValue();
        if (id != null && (StringUtil.startsWith((CharSequence)id, (CharSequence)"com.android.") || id.equals("org.jetbrains.android"))) {
            return;
        }
        if (!PluginXmlDomInspection.isUnderProductionSources(ideaPlugin, module)) {
            return;
        }
        Vendor vendor = ideaPlugin.getVendor();
        if (!DomUtil.hasXml((DomElement)vendor)) {
            holder.createProblem((DomElement)DomUtil.getFileElement((DomElement)ideaPlugin), DevKitBundle.message("inspections.plugin.xml.plugin.should.have.jetbrains.vendor", new Object[0]), new LocalQuickFix[]{new AddMissingMainTag(DevKitBundle.message("inspections.plugin.xml.vendor.specify.jetbrains", new Object[0]), vendor, "JetBrains")});
        } else if (!PluginManagerCore.isVendorJetBrains((String)vendor.getValue())) {
            holder.createProblem((DomElement)vendor, DevKitBundle.message("inspections.plugin.xml.plugin.should.have.jetbrains.vendor", new Object[0]), new LocalQuickFix[0]);
        } else {
            String url2 = vendor.getUrl().getStringValue();
            if (url2 != null && StringUtil.endsWith((CharSequence)url2, (CharSequence)"jetbrains.com")) {
                PluginXmlDomInspection.highlightRedundant(vendor.getUrl(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.vendor.no.url", url2), holder);
            }
        }
        if (DomUtil.hasXml(vendor.getEmail())) {
            PluginXmlDomInspection.highlightRedundant(vendor.getEmail(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.vendor.no.email", new Object[0]), holder);
        }
        if (DomUtil.hasXml(ideaPlugin.getChangeNotes())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getChangeNotes(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.change.notes", new Object[0]), holder);
        }
        if (DomUtil.hasXml(ideaPlugin.getVersion())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getVersion(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.version", new Object[0]), holder);
        }
        if (DomUtil.hasXml((DomElement)ideaPlugin.getIdeaVersion())) {
            PluginXmlDomInspection.highlightRedundant(ideaPlugin.getIdeaVersion(), DevKitBundle.message("inspections.plugin.xml.plugin.jetbrains.no.idea.version", new Object[0]), holder);
        }
    }

    private static void checkPluginIcon(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder, Module module) {
        if (!ideaPlugin.hasRealPluginId()) {
            return;
        }
        if (!PluginXmlDomInspection.isUnderProductionSources(ideaPlugin, module)) {
            return;
        }
        if (Boolean.TRUE == ideaPlugin.getImplementationDetail().getValue()) {
            return;
        }
        Collection pluginIconFiles = FilenameIndex.getVirtualFilesByName((String)PLUGIN_ICON_SVG_FILENAME, (GlobalSearchScope)GlobalSearchScope.moduleScope((Module)module));
        if (pluginIconFiles.isEmpty()) {
            holder.createProblem((DomElement)ideaPlugin, ProblemHighlightType.WEAK_WARNING, DevKitBundle.message("inspections.plugin.xml.no.plugin.icon.svg.file", PLUGIN_ICON_SVG_FILENAME), null, new LocalQuickFix[0]);
        }
    }

    private static void annotateExtensionPoint(final ExtensionPoint extensionPoint, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        Module module;
        if (extensionPoint.getWithElements().isEmpty() && !extensionPoint.collectMissingWithTags().isEmpty()) {
            holder.createProblem((DomElement)extensionPoint, DevKitBundle.message("inspections.plugin.xml.ep.doesnt.have.with", new Object[0]), new LocalQuickFix[]{new AddWithTagFix()});
        }
        PluginXmlDomInspection.checkEpBeanClassAndInterface(extensionPoint, holder);
        PluginXmlDomInspection.checkEpNameAndQualifiedName(extensionPoint, holder);
        if (DomUtil.hasXml(extensionPoint.getQualifiedName())) {
            String epQualifiedName;
            IdeaPlugin ideaPlugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)extensionPoint, IdeaPlugin.class, (boolean)true);
            assert (ideaPlugin != null);
            final String pluginId = ideaPlugin.getPluginId();
            if (pluginId != null && (epQualifiedName = extensionPoint.getQualifiedName().getStringValue()) != null && epQualifiedName.startsWith(pluginId + ".")) {
                holder.createProblem(extensionPoint.getQualifiedName(), ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.ep.qualifiedName.superfluous", new Object[0]), null, new LocalQuickFix[]{new LocalQuickFix(){

                    @IntentionFamilyName
                    @NotNull
                    public String getFamilyName() {
                        return DevKitBundle.message("inspections.plugin.xml.ep.qualifiedName.superfluous.fix", new Object[0]);
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        extensionPoint.getQualifiedName().undefine();
                        extensionPoint.getName().setStringValue(StringUtil.substringAfter((String)epQualifiedName, (String)(pluginId + ".")));
                    }
                }}).highlightWholeElement();
            }
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module = extensionPoint.getModule())) {
            componentModuleRegistrationChecker.checkProperModule(extensionPoint);
        }
    }

    private static void checkEpBeanClassAndInterface(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder) {
        boolean hasBeanClass = DomUtil.hasXml(extensionPoint.getBeanClass());
        boolean hasInterface = DomUtil.hasXml(extensionPoint.getInterface());
        if (hasBeanClass && hasInterface) {
            PluginXmlDomInspection.highlightRedundant(extensionPoint.getBeanClass(), DevKitBundle.message("inspections.plugin.xml.ep.both.beanClass.and.interface", new Object[0]), ProblemHighlightType.GENERIC_ERROR, holder);
            PluginXmlDomInspection.highlightRedundant(extensionPoint.getInterface(), DevKitBundle.message("inspections.plugin.xml.ep.both.beanClass.and.interface", new Object[0]), ProblemHighlightType.GENERIC_ERROR, holder);
        } else if (!hasBeanClass && !hasInterface) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.missing.beanClass.and.interface", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix(extensionPoint.getBeanClass()), new AddDomElementQuickFix(extensionPoint.getInterface())});
        }
    }

    private static void checkEpNameAndQualifiedName(ExtensionPoint extensionPoint, DomElementAnnotationHolder holder) {
        GenericAttributeValue<String> name = extensionPoint.getName();
        GenericAttributeValue<String> qualifiedName = extensionPoint.getQualifiedName();
        boolean hasName = DomUtil.hasXml(name);
        boolean hasQualifiedName = DomUtil.hasXml(qualifiedName);
        if (hasName && hasQualifiedName) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.both.name.and.qualifiedName", new Object[0]), null, new LocalQuickFix[0]);
        } else if (!hasName && !hasQualifiedName) {
            holder.createProblem((DomElement)extensionPoint, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.ep.missing.name.and.qualifiedName", new Object[0]), null, new LocalQuickFix[0]);
        }
        if (hasQualifiedName) {
            if (!PluginXmlDomInspection.isValidEpName(qualifiedName)) {
                String message = DevKitBundle.message("inspections.plugin.xml.invalid.ep.name.description", DevKitBundle.message("inspections.plugin.xml.invalid.ep.qualifiedName", new Object[0]), qualifiedName.getValue());
                holder.createProblem(qualifiedName, ProblemHighlightType.WEAK_WARNING, message, null, new LocalQuickFix[0]);
            }
            return;
        }
        if (hasName && !PluginXmlDomInspection.isValidEpName(name)) {
            String message = DevKitBundle.message("inspections.plugin.xml.invalid.ep.name.description", DevKitBundle.message("inspections.plugin.xml.invalid.ep.name", new Object[0]), name.getValue());
            holder.createProblem(name, ProblemHighlightType.WEAK_WARNING, message, null, new LocalQuickFix[0]);
        }
    }

    private static boolean isValidEpName(GenericAttributeValue<String> nameAttrValue) {
        if (!nameAttrValue.exists()) {
            return true;
        }
        @NonNls String name = (String)nameAttrValue.getValue();
        if (name != null && StringUtil.startsWith((CharSequence)name, (CharSequence)"Pythonid.") && PsiUtil.isIdeaProject(nameAttrValue.getManager().getProject())) {
            return true;
        }
        if (StringUtil.isEmpty((String)name) || !Character.isLowerCase(name.charAt(0)) || StringUtil.toUpperCase((String)name).equals(name) || !StringUtil.isLatinAlphanumeric((CharSequence)name.replace(".", "")) || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        List fragments = StringUtil.split((String)name, (String)".");
        if (fragments.stream().anyMatch(f -> Character.isUpperCase(f.charAt(0)))) {
            return false;
        }
        String epName = (String)fragments.get(fragments.size() - 1);
        fragments.remove(fragments.size() - 1);
        List words = StringUtil.getWordsIn((String)epName);
        return words.stream().noneMatch(w -> fragments.stream().anyMatch(f -> StringUtil.equalsIgnoreCase((CharSequence)w, (CharSequence)f)));
    }

    private static void annotateExtensions(Extensions extensions, DomElementAnnotationHolder holder) {
        GenericAttributeValue<IdeaPlugin> xmlnsAttribute = extensions.getXmlns();
        if (DomUtil.hasXml(xmlnsAttribute)) {
            PluginXmlDomInspection.highlightDeprecated(xmlnsAttribute, DevKitBundle.message("inspections.plugin.xml.use.defaultExtensionNs", new Object[0]), holder, false, true);
            return;
        }
        if (!DomUtil.hasXml(extensions.getDefaultExtensionNs())) {
            holder.createProblem((DomElement)extensions, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitBundle.message("inspections.plugin.xml.specify.defaultExtensionNs.explicitly", "com.intellij"), null, new LocalQuickFix[]{new AddDomElementQuickFix<GenericAttributeValue>(extensions.getDefaultExtensionNs()){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    super.applyFix(project, descriptor);
                    ((GenericAttributeValue)this.myElement).setStringValue("com.intellij");
                }
            }});
        }
    }

    private static void annotateUnresolvedExtension(Extensions.UnresolvedExtension unresolvedExtension, DomElementAnnotationHolder holder) {
        Module module = unresolvedExtension.getModule();
        if (module == null) {
            return;
        }
        final Extensions extensions = (Extensions)unresolvedExtension.getParentOfType(Extensions.class, true);
        assert (extensions != null);
        String qualifiedExtensionId = extensions.getEpPrefix() + unresolvedExtension.getXmlElementName();
        ExtensionPoint extensionPoint = ExtensionPointIndex.findExtensionPoint(module, qualifiedExtensionId);
        if (extensionPoint == null) {
            String message = new HtmlBuilder().append(DevKitBundle.message("error.cannot.resolve.extension.point", qualifiedExtensionId)).nbsp().append((HtmlChunk)HtmlChunk.link((String)DEPENDENCIES_DOC_URL, (String)DevKitBundle.message("error.cannot.resolve.plugin.reference.link.title", new Object[0]))).wrapWith(HtmlChunk.html()).toString();
            holder.createProblem((DomElement)unresolvedExtension, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, message, null, new LocalQuickFix[0]);
            return;
        }
        IdeaPlugin ideaPlugin = (IdeaPlugin)extensionPoint.getParentOfType(IdeaPlugin.class, true);
        assert (ideaPlugin != null);
        final String dependencyId = ideaPlugin.getPluginId();
        LocalQuickFix addDependsFix = new LocalQuickFix(){

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                return DevKitBundle.message("error.cannot.resolve.extension.point.missing.dependency.fix.family.name", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                IdeaPlugin ideaPlugin = (IdeaPlugin)extensions.getParentOfType(IdeaPlugin.class, true);
                assert (ideaPlugin != null);
                Dependency dependency = ideaPlugin.addDependency();
                dependency.setStringValue(dependencyId);
            }
        };
        holder.createProblem((DomElement)unresolvedExtension, DevKitBundle.message("error.cannot.resolve.extension.point.missing.dependency", qualifiedExtensionId), new LocalQuickFix[]{addDependsFix});
    }

    private static void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMin(), holder);
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(ideaVersion.getMax(), holder);
        PluginXmlDomInspection.highlightUntilBuild(ideaVersion, holder);
        GenericAttributeValue<BuildNumber> sinceBuild = ideaVersion.getSinceBuild();
        GenericAttributeValue<BuildNumber> untilBuild = ideaVersion.getUntilBuild();
        if (!DomUtil.hasXml(sinceBuild) && !DomUtil.hasXml(untilBuild)) {
            return;
        }
        BuildNumber sinceBuildNumber = (BuildNumber)sinceBuild.getValue();
        BuildNumber untilBuildNumber = (BuildNumber)untilBuild.getValue();
        if (sinceBuildNumber == null || untilBuildNumber == null) {
            return;
        }
        int compare = Comparing.compare((Comparable)sinceBuildNumber, (Comparable)untilBuildNumber);
        if (compare > 0) {
            holder.createProblem(untilBuild, DevKitBundle.message("inspections.plugin.xml.until.build.must.be.greater.than.since.build", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void highlightUntilBuild(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        String untilBuild = ideaVersion.getUntilBuild().getStringValue();
        if (untilBuild != null && PluginXmlDomInspection.isStarSupported(ideaVersion.getSinceBuild().getStringValue())) {
            Matcher matcher = PluginManager.EXPLICIT_BIG_NUMBER_PATTERN.matcher(untilBuild);
            if (matcher.matches()) {
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.use.asterisk.instead.of.big.number", matcher.group(2)), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(PluginManager.convertExplicitBigNumberInUntilBuildToStar((String)untilBuild))});
            }
            if (untilBuild.matches("\\d+")) {
                int branch = Integer.parseInt(untilBuild);
                String corrected = branch - 1 + ".*";
                holder.createProblem(ideaVersion.getUntilBuild(), DevKitBundle.message("inspections.plugin.xml.until.build.misleading.plain.number", untilBuild, corrected), new LocalQuickFix[]{new CorrectUntilBuildAttributeFix(corrected)});
            }
        }
    }

    private static boolean isStarSupported(String buildNumber) {
        if (buildNumber == null) {
            return false;
        }
        Matcher matcher = BASE_LINE_EXTRACTOR.matcher(buildNumber);
        if (matcher.matches()) {
            int branch = Integer.parseInt(matcher.group(1));
            return branch >= 131;
        }
        return false;
    }

    private static void annotateExtension(Extension extension, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        Module module = extension.getModule();
        String effectiveQualifiedName = extensionPoint.getEffectiveQualifiedName();
        ExtensionPoint.Status status = extensionPoint.getExtensionPointStatus();
        ExtensionPoint.Status.Kind kind2 = status.getKind();
        if (kind2 == ExtensionPoint.Status.Kind.SCHEDULED_FOR_REMOVAL_API) {
            String inVersion = status.getAdditionalData();
            String message = inVersion == null ? DevKitBundle.message("inspections.plugin.xml.deprecated.ep.marked.for.removal", effectiveQualifiedName) : DevKitBundle.message("inspections.plugin.xml.deprecated.ep.marked.for.removal.in.version", effectiveQualifiedName, inVersion);
            PluginXmlDomInspection.highlightDeprecatedMarkedForRemoval(extension, message, holder, false, false);
        } else if (kind2 == ExtensionPoint.Status.Kind.DEPRECATED) {
            PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep", effectiveQualifiedName), holder, false, false);
        } else if (kind2 == ExtensionPoint.Status.Kind.ADDITIONAL_DEPRECATED && module != null) {
            String knownReplacementEp = status.getAdditionalData();
            if (knownReplacementEp == null) {
                PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep", effectiveQualifiedName), holder, false, false);
            } else if (ExtensionPointIndex.findExtensionPoint(module, knownReplacementEp) != null) {
                PluginXmlDomInspection.highlightDeprecated(extension, DevKitBundle.message("inspections.plugin.xml.deprecated.ep.use.replacement", effectiveQualifiedName, knownReplacementEp), holder, false, false);
            }
        } else if (kind2 == ExtensionPoint.Status.Kind.EXPERIMENTAL_API) {
            PluginXmlDomInspection.highlightExperimental(extension, holder);
        } else if (kind2 == ExtensionPoint.Status.Kind.INTERNAL_API && module != null && !PsiUtil.isIdeaProject(module.getProject())) {
            PluginXmlDomInspection.highlightInternal(extension, holder);
        }
        if (ExtensionPoints.ERROR_HANDLER_EP.getName().equals(effectiveQualifiedName)) {
            IdeaPlugin plugin;
            String implementation = extension.getXmlTag().getAttributeValue("implementation");
            if (ITNReporter.class.getName().equals(implementation) && (plugin = (IdeaPlugin)extension.getParentOfType(IdeaPlugin.class, true)) != null) {
                Vendor vendor = plugin.getVendor();
                if (DomUtil.hasXml((DomElement)vendor) && PluginManagerCore.isDevelopedByJetBrains((String)vendor.getValue())) {
                    PluginXmlDomInspection.highlightRedundant(extension, DevKitBundle.message("inspections.plugin.xml.no.need.to.specify.itnReporter", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, holder);
                } else {
                    boolean inPlatformCode;
                    boolean bl = inPlatformCode = module != null && module.getName().startsWith("intellij.platform.");
                    if (!inPlatformCode) {
                        PluginXmlDomInspection.highlightRedundant(extension, DevKitBundle.message("inspections.plugin.xml.third.party.plugins.must.not.use.itnReporter", new Object[0]), holder);
                    }
                }
            }
        }
        if (ServiceDescriptor.class.getName().equals(extensionPoint.getBeanClass().getStringValue())) {
            GenericAttributeValue testServiceImplementation;
            GenericAttributeValue serviceInterface = PluginXmlDomInspection.getAttribute(extension, "serviceInterface");
            GenericAttributeValue serviceImplementation = PluginXmlDomInspection.getAttribute(extension, "serviceImplementation");
            if (serviceInterface != null && serviceImplementation != null && StringUtil.equals((CharSequence)serviceInterface.getStringValue(), (CharSequence)serviceImplementation.getStringValue()) && (testServiceImplementation = PluginXmlDomInspection.getAttribute(extension, "testServiceImplementation")) != null && !DomUtil.hasXml((DomElement)testServiceImplementation)) {
                PluginXmlDomInspection.highlightRedundant((DomElement)serviceInterface, DevKitBundle.message("inspections.plugin.xml.service.interface.class.redundant", new Object[0]), ProblemHighlightType.WARNING, holder);
            }
        }
        List descriptions = extension.getGenericInfo().getAttributeChildrenDescriptions();
        for (DomAttributeChildDescription attributeDescription : descriptions) {
            PsiElement declaration;
            GenericAttributeValue attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension);
            if (attributeValue == null || !DomUtil.hasXml((DomElement)attributeValue)) continue;
            if ("icon".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
            } else if ("order".equals(attributeDescription.getXmlElementName())) {
                PluginXmlDomInspection.annotateOrderAttributeProblems(holder, attributeValue);
            }
            if (!((declaration = attributeDescription.getDeclaration(extension.getManager().getProject())) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)declaration;
            if (psiField.isDeprecated()) {
                PluginXmlDomInspection.highlightDeprecated((DomElement)attributeValue, DevKitBundle.message("inspections.plugin.xml.deprecated.attribute", attributeDescription.getName()), holder, false, true);
                continue;
            }
            if (psiField.hasAnnotation(ApiStatus.Experimental.class.getCanonicalName())) {
                PluginXmlDomInspection.highlightExperimental((DomElement)attributeValue, holder);
                continue;
            }
            if (!psiField.hasAnnotation(ApiStatus.Internal.class.getCanonicalName()) || module == null || PsiUtil.isIdeaProject(module.getProject())) continue;
            PluginXmlDomInspection.highlightInternal((DomElement)attributeValue, holder);
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
            componentModuleRegistrationChecker.checkProperXmlFileForExtension(extension);
        }
    }

    private static void annotateComponent(Component component, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        GenericDomValue<PsiClass> interfaceClassElement;
        PsiClass interfaceClass;
        Module module = component.getModule();
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module)) {
            componentModuleRegistrationChecker.checkProperXmlFileForClass(component, (PsiClass)component.getImplementationClass().getValue());
        }
        if ((interfaceClass = (PsiClass)(interfaceClassElement = component.getInterfaceClass()).getValue()) != null && interfaceClass.equals(component.getImplementationClass().getValue()) && component.getHeadlessImplementationClass().getValue() == null) {
            PluginXmlDomInspection.highlightRedundant(interfaceClassElement, DevKitBundle.message("inspections.plugin.xml.component.interface.class.redundant", new Object[0]), ProblemHighlightType.WARNING, holder);
        }
    }

    private static void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightAttributeNotUsedAnymore(vendor.getLogo(), holder);
        PluginXmlDomInspection.checkTemplateText(vendor, "YourCompany", holder);
        PluginXmlDomInspection.checkMaxLength(vendor, 255, holder);
        PluginXmlDomInspection.checkTemplateText(vendor.getUrl(), "http://www.yourcompany.com", holder);
        PluginXmlDomInspection.checkMaxLength(vendor.getUrl(), 255, holder);
        PluginXmlDomInspection.checkTemplateText(vendor.getEmail(), "support@yourcompany.com", holder);
        PluginXmlDomInspection.checkMaxLength(vendor.getEmail(), 255, holder);
    }

    private static void annotateProductDescriptor(ProductDescriptor productDescriptor, DomElementAnnotationHolder holder) {
        String version;
        PluginXmlDomInspection.checkMaxLength(productDescriptor.getCode(), 15, holder);
        String releaseDate = (String)productDescriptor.getReleaseDate().getValue();
        if (releaseDate != null && !PluginXmlDomInspection.isPlaceHolder(releaseDate)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
                dateFormat.setLenient(false);
                dateFormat.parse(releaseDate);
            }
            catch (ParseException e) {
                holder.createProblem(productDescriptor.getReleaseDate(), DevKitBundle.message("inspections.plugin.xml.product.descriptor.invalid.date", new Object[0]), new LocalQuickFix[0]);
            }
        }
        if ((version = (String)productDescriptor.getReleaseVersion().getValue()) != null && !PluginXmlDomInspection.isPlaceHolder(version)) {
            try {
                Integer.parseInt(version);
            }
            catch (NumberFormatException e) {
                holder.createProblem(productDescriptor.getReleaseVersion(), DevKitBundle.message("inspections.plugin.xml.product.descriptor.invalid.version", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPlaceHolder(@Nullable String value) {
        return value != null && value.length() > 4 && value.startsWith("__") && value.endsWith("__");
    }

    private static void annotateAddToGroup(AddToGroup addToGroup, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(addToGroup.getRelativeToAction())) {
            return;
        }
        if (!DomUtil.hasXml(addToGroup.getAnchor())) {
            holder.createProblem((DomElement)addToGroup, DevKitBundle.message("inspections.plugin.xml.anchor.must.have.relative-to-action", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(addToGroup.getAnchor())});
            return;
        }
        Anchor value = (Anchor)((Object)addToGroup.getAnchor().getValue());
        if (value == Anchor.after || value == Anchor.before) {
            return;
        }
        holder.createProblem(addToGroup.getAnchor(), DevKitBundle.message("inspections.plugin.xml.must.use.after.before.with.relative-to-action", new Object[]{Anchor.after, Anchor.before}), new LocalQuickFix[0]);
    }

    private static void annotateGroup(Group group, DomElementAnnotationHolder holder) {
        GenericAttributeValue useShortcutOfAttribute;
        GenericAttributeValue<PsiClass> clazz;
        GenericAttributeValue iconAttribute = group.getIcon();
        if (DomUtil.hasXml((DomElement)iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
        if (DomUtil.hasXml(clazz = group.getClazz()) && !DomUtil.hasXml((DomElement)group.getId())) {
            holder.createProblem((DomElement)group, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.action.group.id.required", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix((DomElement)group.getId())});
        }
        if (!DomUtil.hasXml((DomElement)(useShortcutOfAttribute = group.getUseShortcutOf()))) {
            return;
        }
        if (!DomUtil.hasXml(clazz)) {
            holder.createProblem((DomElement)group, DevKitBundle.message("inspections.plugin.xml.action.class.required.with.use.shortcut.of", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(group.getClazz())});
            return;
        }
        PsiClass actionGroupClass = (PsiClass)clazz.getValue();
        if (actionGroupClass == null) {
            return;
        }
        LightMethodBuilder canBePerformedMethod = new LightMethodBuilder(actionGroupClass.getManager(), "canBePerformed").setContainingClass(JavaPsiFacade.getInstance((Project)actionGroupClass.getProject()).findClass(ActionGroup.class.getName(), actionGroupClass.getResolveScope())).setModifiers(new String[]{"public"}).setMethodReturnType((PsiType)PsiType.BOOLEAN).addParameter("context", DataContext.class.getName());
        PsiMethod overriddenCanBePerformedMethod = actionGroupClass.findMethodBySignature((PsiMethod)canBePerformedMethod, false);
        if (overriddenCanBePerformedMethod == null) {
            String methodPresentation = PsiFormatUtil.formatMethod((PsiMethod)canBePerformedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2);
            holder.createProblem(clazz, DevKitBundle.message("inspections.plugin.xml.action.must.override.method.with.use.shortcut.of", methodPresentation), new LocalQuickFix[0]);
        }
    }

    private static void annotateAction(Action action, DomElementAnnotationHolder holder, ComponentModuleRegistrationChecker componentModuleRegistrationChecker) {
        Module module;
        GenericAttributeValue<String> iconAttribute = action.getIcon();
        if (DomUtil.hasXml(iconAttribute)) {
            PluginXmlDomInspection.annotateResolveProblems(holder, iconAttribute);
        }
        if (componentModuleRegistrationChecker.isIdeaPlatformModule(module = action.getModule())) {
            componentModuleRegistrationChecker.checkProperXmlFileForClass(action, (PsiClass)action.getClazz().getValue());
        }
    }

    private static void annotateSynonym(Synonym synonym, DomElementAnnotationHolder holder) {
        boolean hasKey = DomUtil.hasXml(synonym.getKey());
        boolean hasText = DomUtil.hasXml(synonym.getText());
        if (!hasKey && !hasText) {
            holder.createProblem((DomElement)synonym, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.synonym.missing.key.and.text", new Object[0]), null, new LocalQuickFix[]{new AddDomElementQuickFix(synonym.getKey()), new AddDomElementQuickFix(synonym.getText())});
        } else if (hasKey && hasText) {
            holder.createProblem((DomElement)synonym, ProblemHighlightType.GENERIC_ERROR, DevKitBundle.message("inspections.plugin.xml.synonym.both.key.and.text", new Object[0]), null, new LocalQuickFix[0]);
        }
    }

    private static void annotateProjectComponent(Component.Project projectComponent, DomElementAnnotationHolder holder) {
        GenericDomValue<Boolean> skipForDefault = projectComponent.getSkipForDefaultProject();
        if (skipForDefault.exists()) {
            PluginXmlDomInspection.highlightDeprecated(skipForDefault, DevKitBundle.message("inspections.plugin.xml.skipForDefaultProject.deprecated", new Object[0]), holder, true, true);
        }
    }

    private static void annotateOrderAttributeProblems(DomElementAnnotationHolder holder, GenericAttributeValue attributeValue) {
        String orderValue = attributeValue.getStringValue();
        if (StringUtil.isEmpty((String)orderValue)) {
            return;
        }
        try {
            LoadingOrder.readOrder((String)orderValue);
        }
        catch (AssertionError ignore) {
            holder.createProblem((DomElement)attributeValue, HighlightSeverity.ERROR, DevKitBundle.message("inspections.plugin.xml.invalid.order.attribute", new Object[0]));
            return;
        }
        PluginXmlDomInspection.annotateResolveProblems(holder, attributeValue);
    }

    private static void annotateResolveProblems(DomElementAnnotationHolder holder, GenericAttributeValue attributeValue) {
        XmlAttributeValue value = attributeValue.getXmlAttributeValue();
        if (value != null) {
            for (PsiReference reference : value.getReferences()) {
                if (reference.resolve() != null) continue;
                holder.createResolveProblem((GenericDomValue)attributeValue, reference);
            }
        }
    }

    private static void highlightRedundant(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightRedundant(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder);
    }

    private static void highlightRedundant(DomElement element, @InspectionMessage String message, ProblemHighlightType highlightType, DomElementAnnotationHolder holder) {
        holder.createProblem(element, highlightType, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)}).highlightWholeElement();
    }

    private static void highlightAttributeNotUsedAnymore(GenericAttributeValue attributeValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)attributeValue)) {
            return;
        }
        PluginXmlDomInspection.highlightDeprecated((DomElement)attributeValue, DevKitBundle.message("inspections.plugin.xml.attribute.not.used.anymore", attributeValue.getXmlElementName()), holder, true, true);
    }

    private static void highlightDeprecated(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement) {
        PluginXmlDomInspection.doHighlightDeprecatedElement(element, message, holder, useRemoveQuickfix, highlightWholeElement, false);
    }

    private static void highlightDeprecatedMarkedForRemoval(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement) {
        PluginXmlDomInspection.doHighlightDeprecatedElement(element, message, holder, useRemoveQuickfix, highlightWholeElement, true);
    }

    private static void doHighlightDeprecatedElement(DomElement element, @InspectionMessage String message, DomElementAnnotationHolder holder, boolean useRemoveQuickfix, boolean highlightWholeElement, boolean forRemoval) {
        ProblemHighlightType problemHighlightType = forRemoval ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
        DomElementProblemDescriptor problem = !useRemoveQuickfix ? holder.createProblem(element, problemHighlightType, message, null, new LocalQuickFix[0]) : holder.createProblem(element, problemHighlightType, message, null, new LocalQuickFix[]{new RemoveDomElementQuickFix(element)});
        if (highlightWholeElement) {
            problem.highlightWholeElement();
        }
    }

    private static void highlightJetbrainsOnly(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.jetbrains.only.api", ApiStatus.Experimental.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void highlightExperimental(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.usage.of.experimental.api", ApiStatus.Experimental.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void highlightInternal(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.usage.of.internal.api", ApiStatus.Internal.class.getCanonicalName()), null, new LocalQuickFix[0]).highlightWholeElement();
    }

    private static void checkTemplateText(GenericDomValue<String> domValue, @NonNls String templateText, DomElementAnnotationHolder holder) {
        if (templateText.equals(domValue.getValue())) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.do.not.use.template.text", templateText), new LocalQuickFix[0]);
        }
    }

    private static void checkTemplateTextContains(GenericDomValue<String> domValue, @NonNls String containsText, DomElementAnnotationHolder holder) {
        String text2 = domValue.getStringValue();
        if (text2 != null && StringUtil.containsIgnoreCase((String)text2, (String)containsText)) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.must.not.contain.template.text", containsText), new LocalQuickFix[0]);
        }
    }

    private static void checkTemplateTextContainsWord(GenericDomValue<String> domValue, DomElementAnnotationHolder holder, String ... templateWords) {
        String text2 = domValue.getStringValue();
        if (text2 == null) {
            return;
        }
        for (String word : StringUtil.getWordsIn((String)text2)) {
            for (String templateWord : templateWords) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)word, (CharSequence)templateWord)) continue;
                holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.must.not.contain.template.text", templateWord), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkMaxLength(GenericDomValue<String> domValue, int maxLength, DomElementAnnotationHolder holder) {
        String value = domValue.getStringValue();
        if (value != null && value.length() > maxLength) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.value.exceeds.max.length", maxLength), new LocalQuickFix[0]);
        }
    }

    private static void checkHasRealText(GenericDomValue<String> domValue, int minimumLength, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(domValue)) {
            return;
        }
        String value = StringUtil.removeHtmlTags((String)StringUtil.notNullize((String)domValue.getStringValue()));
        value = StringUtil.replace((String)value, (String)"<![CDATA[", (String)"");
        if (StringUtil.isEmptyOrSpaces((String)(value = StringUtil.replace((String)value, (String)"]]>", (String)""))) || value.length() < minimumLength) {
            holder.createProblem(domValue, DevKitBundle.message("inspections.plugin.xml.value.must.have.minimum.length", minimumLength), new LocalQuickFix[0]);
        }
    }

    @Tag(value="modules-set")
    public static class PluginModuleSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        public Set<String> modules = new LinkedHashSet<String>();
    }

    private static final class AddMissingMainTag
    implements LocalQuickFix {
        @IntentionFamilyName
        @NotNull
        private final String myFamilyName;
        @NotNull
        private final String myTagName;
        @Nullable
        private final String myTagValue;

        private AddMissingMainTag(@IntentionFamilyName @NotNull String familyName, @NotNull GenericDomValue domValue, @Nullable String tagValue) {
            this.myFamilyName = familyName;
            this.myTagName = domValue.getXmlElementName();
            this.myTagValue = tagValue;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return this.myFamilyName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            IdeaPlugin root = DescriptorUtil.getIdeaPlugin((XmlFile)file);
            if (root != null) {
                XmlTag after = AddMissingMainTag.getLastSubTag(root, new DomElement[]{root.getId(), root.getDescription(), root.getVersion(), root.getName()});
                XmlTag rootTag = root.getXmlTag();
                XmlTag missingTag = rootTag.createChildTag(this.myTagName, rootTag.getNamespace(), this.myTagValue, false);
                XmlTag addedTag = after == null ? rootTag.addSubTag(missingTag, true) : (XmlTag)rootTag.addAfter((PsiElement)missingTag, (PsiElement)after);
                if (StringUtil.isEmpty((String)this.myTagValue)) {
                    int valueStartOffset = addedTag.getValue().getTextRange().getStartOffset();
                    NavigatableAdapter.navigate((Project)project, (VirtualFile)file.getVirtualFile(), (int)valueStartOffset, (boolean)true);
                }
            }
        }

        private static XmlTag getLastSubTag(IdeaPlugin root, DomElement ... children) {
            HashSet<XmlTag> childrenTags = new HashSet<XmlTag>();
            for (DomElement child : children) {
                if (child == null) continue;
                childrenTags.add(child.getXmlTag());
            }
            XmlTag[] subTags = root.getXmlTag().getSubTags();
            for (int i = subTags.length - 1; i >= 0; --i) {
                if (!childrenTags.contains(subTags[i])) continue;
                return subTags[i];
            }
            return null;
        }
    }

    private static class CorrectUntilBuildAttributeFix
    implements LocalQuickFix {
        private final String myCorrectValue;

        CorrectUntilBuildAttributeFix(String correctValue) {
            this.myCorrectValue = correctValue;
        }

        @Nls
        @NotNull
        public String getName() {
            return DevKitBundle.message("inspections.plugin.xml.change.until.build.name", this.myCorrectValue);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.plugin.xml.change.until.build.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class, (boolean)false);
            GenericAttributeValue domElement = DomManager.getDomManager((Project)project).getDomElement(attribute);
            LOG.assertTrue(domElement != null);
            domElement.setStringValue(this.myCorrectValue);
        }
    }
}

