/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.NonDefaultConstructorInspectionKt;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastFacade;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/devkit/inspections/NonDefaultConstructorInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getArea", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint$Area;", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "intellij.devkit.core"})
public final class NonDefaultConstructorInspection
extends DevKitUastInspectionBase {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        javaPsi = aClass.getJavaPsi();
        if (Intrinsics.areEqual((Object)javaPsi.getLanguage().getID(), (Object)"Groovy") || javaPsi.getClassKind() != JvmClassKind.CLASS || PsiUtil.isInnerClass((PsiClass)javaPsi) || PsiUtil.isLocalOrAnonymousClass((PsiClass)javaPsi) || PsiUtil.isAbstractClass((PsiClass)javaPsi) || javaPsi.hasModifierProperty("private")) {
            return null;
        }
        constructors = javaPsi.getConstructors();
        var6_6 = constructors;
        if (((PsiMethod[])var6_6).length == 0) {
            return null;
        }
        area = null;
        isService = false;
        serviceClientKind = null;
        isServiceAnnotation = false;
        extensionPoint = null;
        if (javaPsi.hasAnnotation("com.intellij.openapi.components.Service")) {
            area = null;
            isService = true;
            isServiceAnnotation = true;
        } else {
            if (!NonDefaultConstructorInspectionKt.access$isExtensionBean(aClass)) {
                v0 = NonDefaultConstructorInspectionKt.access$findExtensionPoint(aClass, manager.getProject());
                if (v0 == null) {
                    return null;
                }
                extensionPoint = v0;
            } else if (Intrinsics.areEqual((Object)javaPsi.getName(), (Object)"VcsConfigurableEP")) {
                return null;
            }
            area = this.getArea((ExtensionPoint)extensionPoint);
            v1 = extensionPoint;
            isService = Intrinsics.areEqual((Object)(v1 != null && (v1 = v1.getBeanClass()) != null ? v1.getStringValue() : null), (Object)"com.intellij.openapi.components.ServiceDescriptor");
            if (isService) {
                for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByPsiClass(javaPsi)) {
                    if ((XmlTag)candidate.pointer.getElement() == null) {
                        continue;
                    }
                    v2 = extensionTag.getAttribute("client");
                    if (v2 == null || (v2 = v2.getValue()) == null) {
                        continue;
                    }
                    var16_18 = clientName = v2;
                    var17_20 = Locale.US;
                    v3 = var16_18.toLowerCase(var17_20);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"this as java.lang.String).toLowerCase(locale)");
                    var16_18 = v3;
                    tmp = -1;
                    switch (var16_18.hashCode()) {
                        case 96673: {
                            if (!var16_18.equals("all")) break;
                            tmp = 1;
                            break;
                        }
                        case 98708952: {
                            if (!var16_18.equals("guest")) break;
                            tmp = 2;
                            break;
                        }
                        case 103145323: {
                            if (!var16_18.equals("local")) break;
                            tmp = 3;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v4 = ServiceDescriptor.ClientKind.ALL;
                            break;
                        }
                        case 2: {
                            v4 = ServiceDescriptor.ClientKind.GUEST;
                            break;
                        }
                        case 3: {
                            v4 = ServiceDescriptor.ClientKind.LOCAL;
                            break;
                        }
                        default: {
                            v4 = kind = null;
                        }
                    }
                    if (serviceClientKind == null) {
                        serviceClientKind = kind;
                        continue;
                    }
                    if (serviceClientKind == kind) continue;
                    serviceClientKind = ServiceDescriptor.ClientKind.ALL;
                }
            }
        }
        isAppLevelExtensionPoint = area == null || area == ExtensionPoint.Area.IDEA_APPLICATION;
        errors = null;
        for (PsiMethod method : constructors) {
            block36: {
                block35: {
                    if (NonDefaultConstructorInspectionKt.access$isAllowedParameters(method.getParameterList(), extensionPoint, isAppLevelExtensionPoint, serviceClientKind, isServiceAnnotation)) {
                        return null;
                    }
                    if (errors == null) {
                        errors = (List)new SmartList();
                    }
                    if (!method.isPhysical()) break block35;
                    v5 = method.getIdentifyingElement();
                    v6 = v5;
                    Intrinsics.checkNotNull((Object)v5);
                    break block36;
                }
                v6 = aClass.getSourcePsi();
                if (v6 == null) continue;
                it = var18_21 = v6;
                $i$a$-let-NonDefaultConstructorInspection$checkClass$anchorElement$1 = false;
                v7 = UastFacade.INSTANCE.findPlugin(it);
                if (v7 == null) ** GOTO lbl-1000
                var21_24 = v7;
                var22_25 = (PsiElement)method;
                parent$iv = (UElement)aClass;
                $i$f$convertOpt = false;
                if (element$iv == null) {
                    v8 = null;
                } else {
                    v9 = $this$convertOpt$iv.convertElement((PsiElement)element$iv, parent$iv, UMethod.class);
                    if (!(v9 instanceof UMethod)) {
                        v9 = null;
                    }
                    v8 = (UElement)((UMethod)v9);
                }
                if ((v7 = (UMethod)v8) != null) {
                    v10 = v7.getSourcePsi();
                } else lbl-1000:
                // 2 sources

                {
                    v10 = v6 = null;
                }
                if (v10 == null) {
                    continue;
                }
            }
            anchorElement = v6;
            v11 = kind = isService != false ? DevKitBundle.message("inspections.non.default.warning.type.service", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.type.extension", new Object[0]);
            suffix = area == null ? DevKitBundle.message("inspections.non.default.warning.suffix.project.or.module", new Object[0]) : (isAppLevelExtensionPoint != false ? "" : (area == ExtensionPoint.Area.IDEA_PROJECT ? DevKitBundle.message("inspections.non.default.warning.suffix.project", new Object[0]) : DevKitBundle.message("inspections.non.default.warning.suffix.module", new Object[0])));
            errors.add(manager.createProblemDescriptor(anchorElement, DevKitBundle.message("inspections.non.default.warning.and.suffix.message", new Object[]{kind, suffix}), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        v12 = errors;
        if (v12 != null) {
            $this$toTypedArray$iv = v12;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v13 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (v13 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            v14 = v13;
        } else {
            v14 = null;
        }
        return v14;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExtensionPoint.Area getArea(ExtensionPoint extensionPoint) {
        String areaName;
        ExtensionPoint extensionPoint2 = extensionPoint;
        if (extensionPoint2 == null) {
            return ExtensionPoint.Area.IDEA_APPLICATION;
        }
        String string = areaName = extensionPoint2.getArea().getStringValue();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case -660214604: {
                    if (!string2.equals("IDEA_MODULE")) break;
                    return ExtensionPoint.Area.IDEA_MODULE;
                }
                case -528560719: {
                    if (!string2.equals("IDEA_PROJECT")) break;
                    return ExtensionPoint.Area.IDEA_PROJECT;
                }
            }
        }
        String string3 = (String)extensionPoint.getName().getValue();
        if (string3 == null) return ExtensionPoint.Area.IDEA_APPLICATION;
        String string4 = string3;
        switch (string4.hashCode()) {
            case 350807721: {
                if (!string4.equals("moduleService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_MODULE;
            }
            case -1492183716: {
                if (!string4.equals("projectService")) return ExtensionPoint.Area.IDEA_APPLICATION;
                return ExtensionPoint.Area.IDEA_PROJECT;
            }
        }
        return ExtensionPoint.Area.IDEA_APPLICATION;
    }

    public NonDefaultConstructorInspection() {
        super(UClass.class);
    }
}

