/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;

public class MissingActionUpdateThread
extends DevKitJvmInspection {
    @Nullable
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, final @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        return new DefaultJvmElementVisitor<Boolean>(){

            public Boolean visitClass(@NotNull JvmClass clazz) {
                String className;
                if (clazz.getClassKind() != JvmClassKind.CLASS || clazz.hasModifier(JvmModifier.ABSTRACT) || !JvmInheritanceUtil.isInheritor((JvmClass)clazz, (String)ActionUpdateThreadAware.class.getName())) {
                    return false;
                }
                boolean isAnAction = false;
                boolean hasUpdateMethod = false;
                JvmClass c = clazz;
                while (c != null && !"java.lang.Object".equals(className = c.getQualifiedName()) && !(isAnAction = AnAction.class.getName().equals(className))) {
                    for (JvmMethod method : c.getMethods()) {
                        JvmClass pc;
                        String name = method.getName();
                        if ("getActionUpdateThread".equals(name) && method.getParameters().length == 0) {
                            return null;
                        }
                        if (!"update".equals(name) || hasUpdateMethod) continue;
                        JvmParameter[] parameters = method.getParameters();
                        JvmType pt = parameters.length == 1 ? parameters[0].getType() : null;
                        JvmClass jvmClass = pc = pt instanceof JvmReferenceType ? JvmUtil.resolveClass((JvmReferenceType)((JvmReferenceType)pt)) : null;
                        if (pc == null || !AnActionEvent.class.getName().equals(pc.getQualifiedName())) continue;
                        hasUpdateMethod = true;
                    }
                    c = JvmUtil.resolveClass((JvmReferenceType)c.getSuperClassType());
                }
                if (!isAnAction || hasUpdateMethod) {
                    sink.highlight(DevKitBundle.message("inspections.action.update.thread.message", new Object[0]), new LocalQuickFix[0]);
                }
                return false;
            }
        };
    }
}

