/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class LeakableMapKeyInspection
extends DevKitUastInspectionBase {
    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        return DevKitInspectionBase.isAllowedInPluginsOnly(holder.getFile());
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)holder.getProject());
        PsiFile file = holder.getFile();
        GlobalSearchScope resolveScope = file.getResolveScope();
        PsiClass languageClass = psiFacade.findClass(Language.class.getName(), resolveScope);
        PsiClass fileTypeClass = psiFacade.findClass(FileType.class.getName(), resolveScope);
        PsiClass mapClass = psiFacade.findClass(Map.class.getName(), resolveScope);
        if (languageClass == null || fileTypeClass == null || mapClass == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        UFieldVisitor visitor = new UFieldVisitor(holder, mapClass, Arrays.asList(languageClass, fileTypeClass));
        return UastHintedVisitorAdapter.create((Language)file.getLanguage(), (AbstractUastNonRecursiveVisitor)visitor, (Class[])new Class[]{UField.class});
    }

    private static final class ReplaceKeyQuickFix
    implements LocalQuickFix {
        @NotNull
        @NonNls
        private final String myText;

        private ReplaceKeyQuickFix(@NonNls @NotNull String text2) {
            this.myText = text2;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.leakable.map.key.quick.fix.name", this.myText);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            assert (ReplaceKeyQuickFix.isJavaTypeElement(element));
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiTypeElement stringTypeElement = PsiElementFactory.getInstance((Project)project).createTypeElementFromText(this.myText, element.getContext());
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element.replace((PsiElement)stringTypeElement));
        }

        @NotNull
        static @NotNull LocalQuickFix @NotNull [] createFixesFor(@NotNull PsiElement element) {
            LocalQuickFix[] localQuickFixArray;
            if (ReplaceKeyQuickFix.isJavaTypeElement(element)) {
                ReplaceKeyQuickFix[] replaceKeyQuickFixArray = new ReplaceKeyQuickFix[2];
                replaceKeyQuickFixArray[0] = new ReplaceKeyQuickFix("? super String");
                localQuickFixArray = replaceKeyQuickFixArray;
                replaceKeyQuickFixArray[1] = new ReplaceKeyQuickFix("String");
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            return localQuickFixArray;
        }

        private static boolean isJavaTypeElement(@NotNull PsiElement element) {
            return element instanceof PsiTypeElement && element.getLanguage().is((Language)JavaLanguage.INSTANCE);
        }
    }

    private static final class UFieldVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        @NotNull
        private final PsiClassType myMapType;
        @NotNull
        private final List<? extends PsiClass> myBaseClasses;

        private UFieldVisitor(@NotNull ProblemsHolder holder, @NotNull PsiClass mapClass, @NotNull List<? extends PsiClass> classes) {
            this.myHolder = holder;
            this.myMapType = PsiElementFactory.getInstance((Project)holder.getProject()).createType(mapClass);
            this.myBaseClasses = classes;
        }

        public boolean visitField(@NotNull UField field) {
            PsiClass keyClass;
            PsiType fieldType = field.getType();
            if (this.myMapType.isAssignableFrom(fieldType) && (keyClass = UFieldVisitor.getKeyClass(fieldType)) != null && this.isLeakable(keyClass)) {
                PsiElement typeElement = UFieldVisitor.getTypeElement(field);
                PsiElement element = typeElement == null ? field.getNameIdentifier() : typeElement;
                this.myHolder.registerProblem(element, DevKitBundle.message("inspections.leakable.map.key.text", keyClass.getName()), ReplaceKeyQuickFix.createFixesFor(element));
            }
            return true;
        }

        private boolean isLeakable(@Nullable PsiClass keyClass) {
            return ContainerUtil.exists(this.myBaseClasses, baseClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)keyClass, (PsiClass)baseClass, (boolean)true));
        }

        @Nullable
        private static PsiClass getKeyClass(@NotNull PsiType fieldType) {
            Object[] parameters = fieldType instanceof PsiClassType ? ((PsiClassType)fieldType).getParameters() : PsiType.EMPTY_ARRAY;
            PsiType parameterType = (PsiType)ArrayUtil.getFirstElement((Object[])parameters);
            PsiType boundType = parameterType instanceof PsiWildcardType ? ((PsiWildcardType)parameterType).getBound() : null;
            return PsiTypesUtil.getPsiClass((PsiType)(boundType == null ? parameterType : boundType));
        }

        @Nullable
        private static PsiElement getTypeElement(@NotNull UField field) {
            UTypeReferenceExpression typeReference = field.getTypeReference();
            PsiElement typeReferencePsi = typeReference == null ? null : typeReference.getSourcePsi();
            return typeReferencePsi instanceof PsiTypeElement ? UFieldVisitor.getFirstKey((PsiTypeElement)typeReferencePsi) : typeReferencePsi;
        }

        @Nullable
        private static PsiTypeElement getFirstKey(@NotNull PsiTypeElement typeElement) {
            PsiJavaCodeReferenceElement typeReference = typeElement.getInnermostComponentReferenceElement();
            if (typeReference == null) {
                return null;
            }
            PsiReferenceParameterList parameterList = typeReference.getParameterList();
            return parameterList == null ? null : (PsiTypeElement)ArrayUtil.getFirstElement((Object[])parameterList.getTypeParameterElements());
        }
    }
}

