/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

public class InspectionMappingConsistencyInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (!(element instanceof Extension)) {
            return;
        }
        ExtensionPoint extensionPoint = ((Extension)element).getExtensionPoint();
        if (extensionPoint == null || !InheritanceUtil.isInheritor((PsiClass)((PsiClass)extensionPoint.getBeanClass().getValue()), (String)InspectionEP.class.getName())) {
            return;
        }
        if (InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "key")) {
            if (!InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "bundle")) {
                InspectionMappingConsistencyInspection.checkDefaultBundle(element, holder);
            }
        } else if (!InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "displayName")) {
            InspectionMappingConsistencyInspection.registerProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.displayName.or.key", new Object[0]), "displayName", "key");
        }
        if (InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "groupKey")) {
            if (!InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "bundle") && !InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "groupBundle")) {
                InspectionMappingConsistencyInspection.checkDefaultBundle(element, holder);
            }
        } else if (!InspectionMappingConsistencyInspection.hasDefinedAttribute(element, "groupName")) {
            InspectionMappingConsistencyInspection.registerProblem(element, holder, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.groupName.or.groupKey", new Object[0]), "groupName", "groupKey");
        }
    }

    private static boolean hasDefinedAttribute(DomElement element, @NonNls String attributeName) {
        GenericAttributeValue attribute = DevKitPluginXmlInspectionBase.getAttribute(element, attributeName);
        return attribute != null && DomUtil.hasXml((DomElement)attribute);
    }

    private static void checkDefaultBundle(DomElement element, DomElementAnnotationHolder holder) {
        IdeaPlugin plugin = (IdeaPlugin)DomUtil.getParentOfType((DomElement)element, IdeaPlugin.class, (boolean)true);
        if (plugin != null && !DomUtil.hasXml(plugin.getResourceBundle())) {
            holder.createProblem(element, DevKitBundle.message("inspections.inspection.mapping.consistency.specify.bundle", new Object[0]), new LocalQuickFix[]{new AddDomElementQuickFix(plugin.getResourceBundle())});
        }
    }

    private static void registerProblem(DomElement element, DomElementAnnotationHolder holder, @InspectionMessage String message, String ... createAttrs) {
        if (holder.isOnTheFly()) {
            holder.createProblem(element, message, (LocalQuickFix[])ContainerUtil.map((Object[])createAttrs, attributeName -> {
                XmlTag tag = element.getXmlTag();
                assert (tag != null);
                return new InsertRequiredAttributeFix(tag, (String)attributeName, new String[0], (String)attributeName){
                    final /* synthetic */ String val$attributeName;
                    {
                        this.val$attributeName = string;
                        super(arg0, arg1, arg2);
                    }

                    @NotNull
                    public String getText() {
                        return DevKitBundle.message("inspections.inspection.mapping.consistency.fix.insert.attribute", this.val$attributeName);
                    }
                };
            }, (Object[])new LocalQuickFix[createAttrs.length]));
        } else {
            holder.createProblem(element, message, new LocalQuickFix[0]);
        }
    }
}

