/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DescriptionNotFoundInspectionBase;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;

public class InspectionDescriptionNotFoundInspection
extends DescriptionNotFoundInspectionBase {
    @NonNls
    private static final String INSPECTION_PROFILE_ENTRY = DescriptionType.INSPECTION.getClassName();

    public InspectionDescriptionNotFoundInspection() {
        super(DescriptionType.INSPECTION);
    }

    @Override
    protected boolean skipIfNotRegistered(PsiClass epClass) {
        return InspectionDescriptionNotFoundInspection.isAnyPathMethodOverridden(epClass);
    }

    @Override
    protected boolean checkDynamicDescription(ProblemsHolder holder, Module module, PsiClass psiClass) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        return info.isValid() && info.hasDescriptionFile();
    }

    @Override
    @Nullable
    protected String getDescriptionDir(Module module, PsiClass psiClass) {
        return InspectionDescriptionInfo.create(module, psiClass).getFilename();
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getHasNotDescriptionError(Module module, PsiClass psiClass) {
        InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
        PsiMethod shortNameMethod = info.getShortNameMethod();
        String methodName = shortNameMethod == null ? "" : " [" + shortNameMethod.getName() + "()]";
        return DevKitBundle.message("inspections.inspection.description.optional.short.name", methodName);
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String getHasNotBeforeAfterError() {
        return "";
    }

    private static boolean isAnyPathMethodOverridden(PsiClass psiClass) {
        return !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getStaticDescription", psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionContextClass", psiClass) || !InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn("getDescriptionFileName", psiClass);
    }

    private static boolean isLastMethodDefinitionIn(@NotNull String methodName, @Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        int n = 0;
        PsiMethod[] psiMethodArray = psiClass.findMethodsByName(methodName, false);
        int n2 = psiMethodArray.length;
        if (n < n2) {
            PsiMethod method = psiMethodArray[n];
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return INSPECTION_PROFILE_ENTRY.equals(containingClass.getQualifiedName());
        }
        return InspectionDescriptionNotFoundInspection.isLastMethodDefinitionIn(methodName, psiClass.getSuperClass());
    }
}

