/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public abstract class DevKitInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return DevKitInspectionBase.isAllowed(holder.getFile()) ? this.buildInternalVisitor(holder, isOnTheFly) : PsiElementVisitor.EMPTY_VISITOR;
    }

    protected PsiElementVisitor buildInternalVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return super.buildVisitor(holder, isOnTheFly);
    }

    public static boolean isAllowed(@NotNull PsiFile file) {
        return DevKitInspectionBase.isAllowed(file, __ -> true);
    }

    static boolean isAllowedInPluginsOnly(@NotNull PsiFile file) {
        return DevKitInspectionBase.isAllowed(file, DevKitInspectionBase::isPluginFile);
    }

    private static boolean isAllowed(@NotNull PsiFile file, @NotNull Predicate<? super PsiFile> predicate) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (PsiUtil.isIdeaProject(file.getProject())) {
            return predicate.test((PsiFile)file);
        }
        return DevKitInspectionBase.isInPluginModule(file);
    }

    private static boolean isInPluginModule(@NotNull PsiFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        return PluginModuleType.isPluginModuleOrDependency(module) || PsiUtil.isPluginModule(module);
    }

    private static boolean isPluginFile(@NotNull PsiFile file) {
        String path = file.getVirtualFile().getPath();
        boolean isPlatform = path.contains("/platform/") && !path.contains("/platform/cwm-") && !path.contains("/platform/rd-");
        boolean isRider = path.contains("/Rider/Frontend/rider/") || path.contains("/Rider/Frontend/rider-cpp-core/") || path.contains("/Rider/Frontend/rdclient-dotnet/");
        return !isPlatform && !isRider;
    }
}

