/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ui.InspectionOptionsPanel;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.RegistrationCheckerUtil;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterActionFix;
import org.jetbrains.idea.devkit.inspections.quickfix.RegisterComponentFix;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class ComponentNotRegisteredInspection
extends DevKitJvmInspection {
    private static final Logger LOG = Logger.getInstance(ComponentNotRegisteredInspection.class);
    public boolean CHECK_ACTIONS = true;
    public boolean IGNORE_NON_PUBLIC = true;
    private static final Map<ComponentType, RegistrationCheckerUtil.RegistrationType> COMPONENT_TYPE_TO_REGISTRATION_TYPE = ContainerUtil.immutableMapBuilder().put((Object)ComponentType.APPLICATION, (Object)RegistrationCheckerUtil.RegistrationType.APPLICATION_COMPONENT).put((Object)ComponentType.PROJECT, (Object)RegistrationCheckerUtil.RegistrationType.PROJECT_COMPONENT).put((Object)ComponentType.MODULE, (Object)RegistrationCheckerUtil.RegistrationType.MODULE_COMPONENT).build();

    @Nullable
    public JComponent createOptionsPanel() {
        InspectionOptionsPanel panel2 = new InspectionOptionsPanel();
        final JCheckBox ignoreNonPublic = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.ignore.non.public", new Object[0]), this.IGNORE_NON_PUBLIC);
        ignoreNonPublic.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComponentNotRegisteredInspection.this.IGNORE_NON_PUBLIC = ignoreNonPublic.isSelected();
            }
        });
        final JCheckBox checkJavaActions = new JCheckBox(DevKitBundle.message("inspections.component.not.registered.option.check.actions", new Object[0]), this.CHECK_ACTIONS);
        checkJavaActions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected;
                ComponentNotRegisteredInspection.this.CHECK_ACTIONS = selected = checkJavaActions.isSelected();
                ignoreNonPublic.setEnabled(selected);
            }
        });
        panel2.add((Component)checkJavaActions);
        panel2.add((Component)ignoreNonPublic);
        return panel2;
    }

    @Nullable
    protected JvmElementVisitor<Boolean> buildVisitor(final @NotNull Project project, final @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        return new DefaultJvmElementVisitor<Boolean>(){

            public Boolean visitClass(@NotNull JvmClass clazz) {
                PsiElement sourceElement = clazz.getSourceElement();
                if (!(sourceElement instanceof PsiClass)) {
                    return null;
                }
                ComponentNotRegisteredInspection.this.checkClass(project, (PsiClass)sourceElement, sink);
                return false;
            }
        };
    }

    private void checkClass(@NotNull Project project, @NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink) {
        if (checkedClass.getQualifiedName() == null || checkedClass.getContainingFile().getVirtualFile() == null || checkedClass.hasModifierProperty("abstract") || checkedClass.isEnum() || checkedClass.isDeprecated() || com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)checkedClass) || !this.shouldCheckActionClass(checkedClass)) {
            return;
        }
        GlobalSearchScope scope = checkedClass.getResolveScope();
        PsiClass actionClass = JavaPsiFacade.getInstance((Project)project).findClass(AnAction.class.getName(), scope);
        if (actionClass == null) {
            return;
        }
        if (checkedClass.isInheritor(actionClass, true)) {
            if (!ComponentNotRegisteredInspection.isActionRegistered(checkedClass) && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                RegisterActionFix fix = new RegisterActionFix(checkedClass);
                sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message("new.menu.action.text", new Object[0])), new LocalQuickFix[]{fix});
            }
            return;
        }
        PsiClass baseComponentClass = JavaPsiFacade.getInstance((Project)project).findClass(BaseComponent.class.getName(), scope);
        if (baseComponentClass == null) {
            return;
        }
        if (checkedClass.isInheritor(baseComponentClass, false)) {
            if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, RegistrationCheckerUtil.RegistrationType.ALL_COMPONENTS) == null && ComponentNotRegisteredInspection.canFix(checkedClass)) {
                sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", "Component"), new LocalQuickFix[0]);
            }
            return;
        }
        if (!checkedClass.isInheritor(baseComponentClass, true)) {
            return;
        }
        for (ComponentType componentType : ComponentType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)checkedClass, (String)componentType.myClassName) || !ComponentNotRegisteredInspection.checkComponentRegistration(checkedClass, sink, componentType)) continue;
            return;
        }
    }

    private static boolean checkComponentRegistration(@NotNull PsiClass checkedClass, @NotNull JvmLocalInspection.HighlightSink sink, @NotNull ComponentType componentType) {
        if (ComponentNotRegisteredInspection.findRegistrationType(checkedClass, COMPONENT_TYPE_TO_REGISTRATION_TYPE.get((Object)componentType)) != null) {
            return true;
        }
        if (!ComponentNotRegisteredInspection.canFix(checkedClass)) {
            return true;
        }
        RegisterComponentFix fix = new RegisterComponentFix(componentType, checkedClass);
        sink.highlight(DevKitBundle.message("inspections.component.not.registered.message", DevKitBundle.message(componentType.myPropertyKey, new Object[0])), new LocalQuickFix[]{fix});
        return false;
    }

    private static PsiClass findRegistrationType(@NotNull PsiClass checkedClass, @NotNull RegistrationCheckerUtil.RegistrationType type2) {
        Set<PsiClass> types = RegistrationCheckerUtil.getRegistrationTypes(checkedClass, type2);
        return (PsiClass)ContainerUtil.getFirstItem(types);
    }

    private boolean shouldCheckActionClass(@NotNull PsiClass psiClass) {
        if (!this.CHECK_ACTIONS) {
            return false;
        }
        return !this.IGNORE_NON_PUBLIC || psiClass.hasModifierProperty("public");
    }

    private static boolean isActionRegistered(@NotNull PsiClass actionClass) {
        PsiClass registrationType = ComponentNotRegisteredInspection.findRegistrationType(actionClass, RegistrationCheckerUtil.RegistrationType.ACTION);
        if (registrationType != null) {
            return true;
        }
        for (PsiMethod method : actionClass.getConstructors()) {
            Query search = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true);
            if (search.findFirst() == null) continue;
            return true;
        }
        Query search = ReferencesSearch.search((PsiElement)actionClass, (SearchScope)actionClass.getUseScope());
        for (PsiReference reference : search) {
            PsiJavaCodeReferenceElement classReference;
            PsiNewExpression newExpression;
            if (!(reference instanceof PsiJavaCodeReferenceElement) || (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiNewExpression.class)) == null || (classReference = newExpression.getClassReference()) == null || !classReference.getQualifiedName().equals(actionClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean canFix(@NotNull PsiClass psiClass) {
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        LOG.assertTrue(psiFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)psiFile.getVirtualFile(), (Project)project);
        return PluginModuleType.isPluginModuleOrDependency(module) || module != null && PsiUtil.isPluginModule(module);
    }
}

