/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.PluginXmlDomInspection;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001!B5\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0012\u0010 \u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;", "", "moduleToModuleSet", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "", "Lorg/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$PluginModuleSet;", "ignoredClasses", "", "annotationHolder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "(Lcom/intellij/openapi/util/ClearableLazyValue;Ljava/util/List;Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;)V", "checkProperModule", "", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "checkProperXmlFileForClass", "", "element", "Lcom/intellij/util/xml/DomElement;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkProperXmlFileForExtension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "findMatchingImplModule", "Lcom/intellij/openapi/module/Module;", "module", "findModulePluginXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getExtensionPointClass", "Lcom/intellij/psi/PsiElement;", "isIdeaPlatformModule", "shouldCheckExtensionPointClassAttribute", "MoveRegistrationQuickFix", "intellij.devkit.core"})
public final class ComponentModuleRegistrationChecker {
    private final ClearableLazyValue<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet;
    private final List<String> ignoredClasses;
    private final DomElementAnnotationHolder annotationHolder;

    /*
     * WARNING - void declaration
     */
    public final void checkProperModule(@NotNull ExtensionPoint extensionPoint) {
        block2: {
            void extensionPointClass;
            Module module;
            PsiClass effectiveEpClass = extensionPoint.getEffectiveClass();
            if (this.shouldCheckExtensionPointClassAttribute(effectiveEpClass) && this.checkProperXmlFileForClass(extensionPoint, effectiveEpClass)) {
                return;
            }
            String shortName = StringsKt.substringAfterLast$default((String)extensionPoint.getEffectiveQualifiedName(), (char)'.', null, (int)2, null);
            Module module2 = module = extensionPoint.getModule();
            Intrinsics.checkNotNull((Object)module2);
            Project project = module2.getProject();
            PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
            if (psiSearchHelper.isCheapEnoughToSearch(shortName, scope, null, null) != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) break block2;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            psiSearchHelper.processElementsWithWord(new TextOccurenceProcessor(this, (Ref.ObjectRef)extensionPointClass){
                final /* synthetic */ ComponentModuleRegistrationChecker this$0;
                final /* synthetic */ Ref.ObjectRef $extensionPointClass;

                public final boolean execute(@NotNull PsiElement element, int $noName_1) {
                    this.$extensionPointClass.element = ComponentModuleRegistrationChecker.access$getExtensionPointClass(this.this$0, element);
                    return (PsiClass)this.$extensionPointClass.element == null;
                }
                {
                    this.this$0 = componentModuleRegistrationChecker;
                    this.$extensionPointClass = objectRef;
                }
            }, (SearchScope)scope, shortName, (short)4, true, false);
            PsiClass psiClass = (PsiClass)extensionPointClass.element;
            if (psiClass != null) {
                PsiClass psiClass2;
                PsiClass it = psiClass2 = psiClass;
                boolean bl = false;
                this.checkProperXmlFileForClass(extensionPoint, it);
            }
        }
    }

    private final PsiClass getExtensionPointClass(PsiElement element) {
        PsiClassType psiClassType;
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return null;
        }
        PsiField epName = psiField;
        PsiType psiType = epName.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        PsiClassType psiClass = psiClassType;
        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"com.intellij.openapi.extensions.ExtensionPointName")) {
            return epName.getContainingClass();
        }
        return null;
    }

    public final void checkProperXmlFileForExtension(@NotNull Extension element) {
        CharSequence beanClass;
        CharSequence charSequence = element.getXmlTag().getAttributeValue("language");
        if (!(charSequence == null || charSequence.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.lang.LanguageExtensionPoint")) {
                return;
            }
        }
        if (!((beanClass = (CharSequence)element.getXmlTag().getAttributeValue("filetype")) == null || beanClass.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.openapi.fileTypes.FileTypeExtensionPoint")) {
                return;
            }
        }
        for (DomAttributeChildDescription attributeDescription : element.getGenericInfo().getAttributeChildrenDescriptions()) {
            PsiClass psiClass;
            GenericAttributeValue attributeValue;
            String attributeName = attributeDescription.getName();
            if (Intrinsics.areEqual((Object)attributeName, (Object)"forClass") || Intrinsics.areEqual((Object)attributeName, (Object)"serviceInterface") && Intrinsics.areEqual((Object)element.getXmlTag().getAttributeValue("overrides"), (Object)"true") || (attributeValue = attributeDescription.getDomAttributeValue((DomElement)element)) == null || !DomUtil.hasXml((DomElement)((DomElement)attributeValue)) || !(attributeValue.getConverter() instanceof PluginPsiClassConverter)) continue;
            if ((PsiClass)attributeValue.getValue() == null) {
                continue;
            }
            if (!this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
        for (DomFixedChildDescription childDescription : element.getGenericInfo().getFixedChildrenDescriptions()) {
            XmlTag tag;
            DomElement domElement;
            if ((DomElement)CollectionsKt.firstOrNull((List)childDescription.getValues((DomElement)element)) == null) {
                continue;
            }
            if (domElement.getXmlTag() == null) {
                continue;
            }
            Project project = tag.getProject();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(tag.getValue().getText(), GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || !this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
    }

    private final boolean shouldCheckExtensionPointClassAttribute(PsiClass psiClass) {
        PsiField[] psiFieldArray = psiClass;
        if (psiClass != null && (psiFieldArray = psiFieldArray.getFields()) != null) {
            PsiField[] $this$forEach$iv = psiFieldArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiField element$iv;
                PsiField field = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!TypeUtils.typeEquals((String)ExtensionPointName.class.getCanonicalName(), (PsiType)field.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean checkProperXmlFileForClass(@NotNull DomElement element, @Nullable PsiClass psiClass) {
        Module implModule;
        PsiClass psiClass2;
        if (psiClass == null) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)this.ignoredClasses, (Object)psiClass.getQualifiedName())) {
            return false;
        }
        PsiClass it = psiClass2 = psiClass;
        boolean bl = false;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)it));
        if (module == null) {
            return false;
        }
        Module definingModule = module;
        Module elementModule = element.getModule();
        if (elementModule == null || Intrinsics.areEqual((Object)definingModule, (Object)elementModule)) {
            return false;
        }
        PluginXmlDomInspection.PluginModuleSet definingPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(definingModule.getName());
        PluginXmlDomInspection.PluginModuleSet elementPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(elementModule.getName());
        if (definingPlugin != null && definingPlugin == elementPlugin) {
            return false;
        }
        Module pluginXmlModule = definingModule;
        XmlFile modulePluginXmlFile = this.findModulePluginXmlFile(pluginXmlModule);
        if (modulePluginXmlFile == null && (implModule = this.findMatchingImplModule(pluginXmlModule)) != null) {
            pluginXmlModule = implModule;
            modulePluginXmlFile = this.findModulePluginXmlFile(implModule);
        }
        MoveRegistrationQuickFix fix = modulePluginXmlFile != null ? new MoveRegistrationQuickFix(pluginXmlModule, modulePluginXmlFile.getName()) : null;
        this.annotationHolder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.element.registered.wrong.module", definingModule.getName(), psiClass.getQualifiedName()), null, new LocalQuickFix[]{fix});
        return true;
    }

    public final boolean isIdeaPlatformModule(@Nullable Module module) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (module == null || !PsiUtil.isIdeaProject(module.getProject())) {
            return false;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        VirtualFile[] virtualFileArray = contentRoots;
        if (virtualFileArray.length == 0) {
            return false;
        }
        for (VirtualFile parent = contentRoots[0].getParent(); parent != null; parent = parent.getParent()) {
            if (Intrinsics.areEqual((Object)parent.getName(), (Object)"plugins")) {
                return false;
            }
            if (parent.findChild(".idea") == null) continue;
            return true;
        }
        return true;
    }

    private final Module findMatchingImplModule(Module module) {
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(module.getName() + ".impl");
    }

    private final XmlFile findModulePluginXmlFile(Module module) {
        for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots(false)) {
            VirtualFile metaInf = sourceRoot.findChild("META-INF");
            if (metaInf == null || !metaInf.isDirectory()) continue;
            for (VirtualFile file : metaInf.getChildren()) {
                PsiFile psiFile;
                if (!StringsKt.endsWith$default((String)file.getName(), (String)"Plugin.xml", (boolean)false, (int)2, null) || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile;
            }
        }
        return null;
    }

    public ComponentModuleRegistrationChecker(@NotNull ClearableLazyValue<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet, @NotNull List<String> ignoredClasses, @NotNull DomElementAnnotationHolder annotationHolder) {
        this.moduleToModuleSet = moduleToModuleSet;
        this.ignoredClasses = ignoredClasses;
        this.annotationHolder = annotationHolder;
    }

    public static final /* synthetic */ PsiClass access$getExtensionPointClass(ComponentModuleRegistrationChecker $this, PsiElement element) {
        return $this.getExtensionPointClass(element);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0017J\b\u0010\u000e\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker$MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.devkit.core"})
    public final class MoveRegistrationQuickFix
    implements LocalQuickFix {
        private final Module myTargetModule;
        private final String myTargetFileName;

        @Nls
        @NotNull
        public String getName() {
            return DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.name", this.myTargetFileName);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block16: {
                PsiElement psiElement;
                XmlTag tag;
                block15: {
                    XmlTag newParentTag;
                    block14: {
                        PsiElement psiElement2;
                        PsiElement anchor;
                        PsiElement psiElement3;
                        block13: {
                            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
                            if (xmlTag == null) {
                                return;
                            }
                            tag = xmlTag;
                            XmlTag xmlTag2 = tag.getParentTag();
                            if (xmlTag2 == null) {
                                return;
                            }
                            XmlTag parentTag = xmlTag2;
                            XmlFile xmlFile = ComponentModuleRegistrationChecker.this.findModulePluginXmlFile(this.myTargetModule);
                            if (xmlFile == null) {
                                return;
                            }
                            XmlFile targetFile = xmlFile;
                            XmlTag xmlTag3 = targetFile.getRootTag();
                            if (xmlTag3 == null) {
                                return;
                            }
                            XmlTag rootTag = xmlTag3;
                            XmlTag xmlTag4 = tag.getParentTag();
                            Intrinsics.checkNotNull((Object)xmlTag4);
                            Object[] subTags = rootTag.findSubTags(xmlTag4.getName());
                            XmlTag xmlTag5 = (XmlTag)ArraysKt.firstOrNull((Object[])subTags);
                            if (xmlTag5 == null) {
                                XmlTag xmlTag6;
                                XmlTag $this$apply = xmlTag6 = rootTag.addSubTag(rootTag.createChildTag(parentTag.getLocalName(), "", null, false), false);
                                boolean bl = false;
                                for (XmlAttribute attribute : parentTag.getAttributes()) {
                                    $this$apply.setAttribute(attribute.getName(), attribute.getValue());
                                }
                                xmlTag5 = xmlTag6;
                            }
                            newParentTag = xmlTag5;
                            XmlTag[] $this$lastOrNull$iv = newParentTag.getSubTags();
                            boolean $i$f$lastOrNull = false;
                            int n = $this$lastOrNull$iv.length + -1;
                            if (0 <= n) {
                                do {
                                    XmlTag element$iv;
                                    int index$iv = n--;
                                    XmlTag it = element$iv = $this$lastOrNull$iv[index$iv];
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)tag.getName())) continue;
                                    psiElement3 = element$iv;
                                    break block13;
                                } while (0 <= n);
                            }
                            psiElement3 = null;
                        }
                        if ((psiElement = (anchor = psiElement3)) == null) break block14;
                        PsiElement it = psiElement2 = psiElement;
                        boolean bl = false;
                        psiElement = newParentTag.addAfter((PsiElement)tag, anchor);
                        if (psiElement != null) break block15;
                    }
                    psiElement = (PsiElement)newParentTag.addSubTag(tag, false);
                }
                PsiElement newTag = psiElement;
                tag.delete();
                PsiElement psiElement4 = newTag;
                if (!(psiElement4 instanceof Navigatable)) {
                    psiElement4 = null;
                }
                Navigatable navigatable = (Navigatable)psiElement4;
                if (navigatable == null) break block16;
                navigatable.navigate(true);
            }
        }

        public MoveRegistrationQuickFix(@NotNull Module myTargetModule, String myTargetFileName) {
            this.myTargetModule = myTargetModule;
            this.myTargetFileName = myTargetFileName;
        }
    }
}

