/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.SchemeConvertorEPBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.i18n.DevKitI18nBundle;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.util.DescriptorI18nUtil;
import org.jetbrains.idea.devkit.util.PluginPlatformInfo;
import org.jetbrains.uast.UExpression;

public class PluginXmlI18nInspection
extends DevKitPluginXmlInspectionBase {
    private static final Logger LOG = Logger.getInstance(PluginXmlI18nInspection.class);

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof ActionOrGroup) {
            PluginXmlI18nInspection.highlightActionOrGroup(holder, (ActionOrGroup)element);
        } else if (element instanceof Separator) {
            PluginXmlI18nInspection.highlightSeparator(holder, (Separator)element);
        } else if (element instanceof OverrideText) {
            PluginXmlI18nInspection.highlightOverrideText(holder, (OverrideText)element);
        } else if (element instanceof Extension) {
            PluginXmlI18nInspection.highlightExtension(holder, (Extension)element);
        }
    }

    private static void highlightExtension(DomElementAnnotationHolder holder, Extension extension) {
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
        if (beanClass == null) {
            return;
        }
        String epName = extensionPoint.getEffectiveQualifiedName();
        if (LocalInspectionEP.LOCAL_INSPECTION.getName().equals(epName) || InspectionEP.GLOBAL_INSPECTION.getName().equals(epName)) {
            if (PluginXmlI18nInspection.isInternal(extension, "isInternal")) {
                return;
            }
            GenericAttributeValue implementationClass = PluginXmlI18nInspection.getAttribute(extension, "implementationClass");
            if (implementationClass == null || implementationClass.getStringValue() == null) {
                return;
            }
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "displayName", new InspectionI18NQuickFix());
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "groupName", null);
        } else if (IntentionManagerImpl.EP_INTENTION_ACTIONS.getName().equals(epName)) {
            PluginXmlI18nInspection.checkNonLocalizableTag(holder, extension, "category", null);
        } else if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)ConfigurableEP.class.getName())) {
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "displayName", null);
            for (DomElement nestedConfigurable : DomUtil.getDefinedChildren((DomElement)extension, (boolean)true, (boolean)false)) {
                PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, nestedConfigurable, "displayName", null);
            }
        } else if (InheritanceUtil.isInheritor((PsiClass)beanClass, (String)SchemeConvertorEPBase.class.getName())) {
            PluginXmlI18nInspection.checkNonLocalizableAttribute(holder, extension, "name", null);
        }
    }

    private static void checkNonLocalizableAttribute(DomElementAnnotationHolder holder, DomElement element, @NonNls String attributeName, @Nullable LocalQuickFix fix) {
        PluginXmlI18nInspection.highlightNonLocalizableElement(holder, (GenericDomValue)PluginXmlI18nInspection.getAttribute(element, attributeName), attributeName, fix);
    }

    private static void checkNonLocalizableTag(DomElementAnnotationHolder holder, DomElement element, String tagName, @Nullable LocalQuickFix quickFix) {
        PluginXmlI18nInspection.highlightNonLocalizableElement(holder, PluginXmlI18nInspection.getTag(element, tagName), tagName, quickFix);
    }

    private static void highlightNonLocalizableElement(DomElementAnnotationHolder holder, GenericDomValue valueElement, @NonNls String valueElementName, @Nullable LocalQuickFix fix) {
        if (valueElement != null && valueElement.getStringValue() != null) {
            holder.createProblem((DomElement)valueElement, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.family.name", valueElementName), null, new LocalQuickFix[]{fix});
        }
    }

    private static void highlightSeparator(DomElementAnnotationHolder holder, Separator separator) {
        if (!DomUtil.hasXml(separator.getText())) {
            return;
        }
        BuildNumber buildNumber = PluginPlatformInfo.forDomElement((DomElement)separator).getSinceBuildNumber();
        if (buildNumber != null && buildNumber.getBaselineVersion() >= 202) {
            holder.createProblem((DomElement)separator, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.key", new Object[0]), null, new LocalQuickFix[]{new SeparatorKeyI18nQuickFix()});
        }
    }

    private static void highlightOverrideText(DomElementAnnotationHolder holder, OverrideText overrideText) {
        if (!DomUtil.hasXml(overrideText.getText())) {
            return;
        }
        DomElement parent = overrideText.getParent();
        PropertiesFile propertiesFile = DescriptorI18nUtil.findBundlePropertiesFile(parent);
        holder.createProblem((DomElement)overrideText, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]), null, new LocalQuickFix[]{new ActionOrGroupQuickFixAction(propertiesFile != null ? propertiesFile.getVirtualFile() : null, parent instanceof Action)});
    }

    private static void highlightActionOrGroup(@NotNull DomElementAnnotationHolder holder, @NotNull ActionOrGroup actionOrGroup) {
        String id = actionOrGroup.getId().getStringValue();
        if (id == null) {
            return;
        }
        String text2 = actionOrGroup.getText().getStringValue();
        String desc = actionOrGroup.getDescription().getStringValue();
        if (text2 == null && desc == null) {
            return;
        }
        if (PluginXmlI18nInspection.isInternal(actionOrGroup, "internal")) {
            return;
        }
        PropertiesFile propertiesFile = DescriptorI18nUtil.findBundlePropertiesFile(actionOrGroup);
        holder.createProblem((DomElement)actionOrGroup, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]), null, new LocalQuickFix[]{new ActionOrGroupQuickFixAction(propertiesFile != null ? propertiesFile.getVirtualFile() : null, actionOrGroup instanceof Action)});
    }

    private static boolean isInternal(@NotNull DomElement action, String internalAttributeName) {
        GenericAttributeValue internalAttribute = PluginXmlI18nInspection.getAttribute(action, internalAttributeName);
        return internalAttribute != null && "true".equals(internalAttribute.getStringValue());
    }

    private static void choosePropertiesFileAndExtract(Project project, List<XmlTag> tags, Consumer<String> doFixConsumer) {
        ResourceBundleManager resourceBundleManager;
        try {
            resourceBundleManager = ResourceBundleManager.getManager((Collection)ContainerUtil.map(tags, x -> x.getContainingFile()), (Project)project);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            resourceBundleManager = null;
        }
        @NotNull Set contextModules = ContainerUtil.map2Set(tags, x -> ModuleUtilCore.findModuleForPsiElement((PsiElement)x));
        ResourceBundleManager finalResourceBundleManager = resourceBundleManager;
        List files = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (List)ReadAction.compute(() -> finalResourceBundleManager != null ? finalResourceBundleManager.suggestPropertiesFiles(contextModules) : I18nUtil.defaultSuggestPropertiesFiles((Project)project, (Set)contextModules)), DevKitBundle.message("progress.title.calculate.target.properties.file", new Object[0]), true, project);
        if (files == null || files.isEmpty()) {
            return;
        }
        if (files.size() == 1) {
            doFixConsumer.accept((String)files.get(0));
            return;
        }
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(files).setNamerForFiltering(x -> x).setTitle(DevKitI18nBundle.message("inspections.plugin.xml.i18n.choose.bundle.4inspections.title", new Object[0])).setItemChosenCallback(selected -> doFixConsumer.accept((String)selected));
        builder2.createPopup().showCenteredInCurrentWindow(project);
    }

    @NotNull
    private static String getBundleQName(@NotNull Project project, PropertiesFile propertiesFile) {
        String relativePath;
        String baseName = propertiesFile.getResourceBundle().getBaseName();
        VirtualFile virtualFile = propertiesFile.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        if (sourceRootForFile != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRootForFile, (char)'.')) != null) {
            return FileUtil.getNameWithoutExtension((String)relativePath);
        }
        return baseName;
    }

    private static List<XmlTag> getTags(List<CommonProblemDescriptor> descriptors) {
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>();
        for (CommonProblemDescriptor d : descriptors) {
            PsiElement parent;
            if (!(d instanceof ProblemDescriptor)) continue;
            PsiElement e = ((ProblemDescriptor)d).getPsiElement();
            if (e instanceof XmlTag) {
                tags.add((XmlTag)e);
                continue;
            }
            if (!(e instanceof XmlAttributeValue) || !((parent = e.getParent()) instanceof XmlAttribute)) continue;
            ContainerUtil.addIfNotNull(tags, (Object)((XmlAttribute)parent).getParent());
        }
        return tags;
    }

    @Nullable
    private static PropertiesFile findPropertiesFile(Project project, String propertiesFilePath) {
        VirtualFile propertiesVFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)propertiesFilePath));
        if (propertiesVFile != null) {
            return PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)project).findFile(propertiesVFile));
        }
        return null;
    }

    private static class SeparatorKeyI18nQuickFix
    implements LocalQuickFix,
    BatchQuickFix {
        private SeparatorKeyI18nQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return DevKitI18nBundle.message("inspections.plugin.xml.i18n.key", new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag xml = (XmlTag)descriptor.getPsiElement();
            if (xml == null) {
                return;
            }
            SeparatorKeyI18nQuickFix.doFix(project, Collections.singletonList(xml));
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            SeparatorKeyI18nQuickFix.doFix(project, PluginXmlI18nInspection.getTags(Arrays.asList(descriptors)));
        }

        private static void doFix(@NotNull Project project, List<XmlTag> tags) {
            PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                PropertiesFile propertiesFile = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                if (propertiesFile != null) {
                    ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                    psiFiles.add(propertiesFile.getContainingFile());
                    for (XmlTag tag : tags) {
                        psiFiles.add(tag.getContainingFile());
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.key.command.name", new Object[0]), null, () -> {
                        for (XmlTag tag : tags) {
                            SeparatorKeyI18nQuickFix.registerPropertyKey(project, tag, propertiesFile);
                        }
                    }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
                }
            });
        }

        private static void registerPropertyKey(@NotNull Project project, XmlTag xml, PropertiesFile propertiesFile) {
            DomElement domElement = DomUtil.getDomElement((PsiElement)xml);
            assert (domElement instanceof Separator);
            Separator separator = (Separator)domElement;
            String text2 = StringUtil.defaultIfEmpty((String)separator.getText().getStringValue(), (String)"noText");
            @NonNls String key = "separator." + StringUtil.join((Object[])NameUtilCore.splitNameIntoWords((String)text2), s -> StringUtil.trim((String)StringUtil.decapitalize((String)s)), (String)".");
            JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile), key, StringUtil.unescapeXmlEntities((String)text2), new UExpression[0]);
            separator.getText().undefine();
            separator.getKey().setValue((Object)key);
        }
    }

    private static final class ActionOrGroupQuickFixAction
    implements LocalQuickFix,
    BatchQuickFix {
        private final VirtualFile myPropertiesFile;
        private final boolean myIsAction;

        private ActionOrGroupQuickFixAction(VirtualFile file, boolean isAction) {
            this.myPropertiesFile = file;
            this.myIsAction = isAction;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return DevKitI18nBundle.message("inspections.plugin.xml.i18n.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            LightVirtualFile nullValue = new LightVirtualFile();
            Map<VirtualFile, List<CommonProblemDescriptor>> byPropertyFiles = Arrays.stream(descriptors).filter(d -> d instanceof ProblemDescriptor).collect(Collectors.groupingBy(arg_0 -> ActionOrGroupQuickFixAction.lambda$applyFix$1((VirtualFile)nullValue, arg_0)));
            for (Map.Entry<VirtualFile, List<CommonProblemDescriptor>> entry : byPropertyFiles.entrySet()) {
                VirtualFile propertyFile = entry.getKey().equals(nullValue) ? null : entry.getKey();
                this.doFix(project, propertyFile, PluginXmlI18nInspection.getTags(entry.getValue()));
            }
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlTag)) {
                return;
            }
            XmlTag tag = (XmlTag)element;
            this.doFix(project, this.myPropertiesFile, Collections.singletonList(tag));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private void doFix(@NotNull Project project, VirtualFile file, List<XmlTag> tags) {
            if (file == null) {
                PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                    PropertiesFile propertiesFile = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                    this.doFix(project, tags, propertiesFile, true);
                });
            } else {
                PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)PsiManager.getInstance((Project)project).findFile(file));
                this.doFix(project, tags, propertiesFile, false);
            }
        }

        private void doFix(@NotNull Project project, List<XmlTag> tags, PropertiesFile propertiesFile, boolean attachResourceBundle) {
            if (propertiesFile != null) {
                ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                psiFiles.add(propertiesFile.getContainingFile());
                for (XmlTag t : tags) {
                    psiFiles.add(t.getContainingFile());
                }
                WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.command.name", new Object[0]), null, () -> {
                    if (attachResourceBundle) {
                        ActionOrGroupQuickFixAction.createResourceBundleTag(project, tags, propertiesFile);
                    }
                    ActionOrGroupQuickFixAction.extractTextAndDescription(project, tags, propertiesFile, this.myIsAction);
                }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
            }
        }

        private static void createResourceBundleTag(@NotNull Project project, List<XmlTag> tags, PropertiesFile propertiesFile) {
            for (XmlTag tag : tags) {
                XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
                LOG.assertTrue(rootTag != null);
                if (rootTag.findFirstSubTag("resource-bundle") != null) continue;
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
                XmlTag rbTag = elementFactory.createTagFromText((CharSequence)("<resource-bundle>" + PluginXmlI18nInspection.getBundleQName(project, propertiesFile) + "</resource-bundle>"));
                rootTag.addSubTag(rbTag, false);
            }
        }

        private static void extractTextAndDescription(@NotNull Project project, Collection<XmlTag> tags, PropertiesFile propertiesFile, boolean isAction) {
            for (XmlTag tag : tags) {
                String actionOrGroupPrefix;
                String text2 = tag.getAttributeValue("text");
                tag.setAttribute("text", null);
                String description2 = tag.getAttributeValue("description");
                tag.setAttribute("description", null);
                Object id = tag.getName().equals("override-text") ? Objects.requireNonNull(tag.getParentTag()).getAttributeValue("id") + "." + tag.getAttributeValue("place") : tag.getAttributeValue("id");
                List<PropertiesFile> propertiesFiles = Collections.singletonList(propertiesFile);
                String string = actionOrGroupPrefix = isAction ? "action." : "group.";
                if (text2 != null) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, propertiesFiles, actionOrGroupPrefix + (String)id + ".text", text2, new UExpression[0]);
                }
                if (description2 != null) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, propertiesFiles, actionOrGroupPrefix + (String)id + ".description", description2, new UExpression[0]);
                }
                tag.processElements(element -> {
                    IElementType type2;
                    PsiElement next;
                    if (element instanceof PsiWhiteSpace && element.textContains('\n') && (next = element.getNextSibling()) instanceof LeafPsiElement && ((type2 = ((LeafPsiElement)next).getElementType()) == XmlTokenType.XML_TAG_END || type2 == XmlTokenType.XML_EMPTY_ELEMENT_END)) {
                        element.delete();
                        return false;
                    }
                    return true;
                }, tag.getFirstChild());
            }
        }

        private static /* synthetic */ VirtualFile lambda$applyFix$1(VirtualFile nullValue, CommonProblemDescriptor cd) {
            return (VirtualFile)ObjectUtils.notNull((Object)((ActionOrGroupQuickFixAction)cd.getFixes()[0]).myPropertiesFile, (Object)nullValue);
        }
    }

    private static class InspectionI18NQuickFix
    implements LocalQuickFix,
    BatchQuickFix {
        private InspectionI18NQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.family.name", "displayName");
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            XmlTag xml = null;
            if (element instanceof XmlTag) {
                xml = (XmlTag)element;
            } else if (element instanceof XmlAttributeValue) {
                PsiElement parent = element.getParent();
                XmlTag xmlTag = xml = parent instanceof XmlAttribute ? ((XmlAttribute)parent).getParent() : null;
            }
            if (xml == null) {
                return;
            }
            InspectionI18NQuickFix.doFix(project, Collections.singletonList(xml));
        }

        public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            InspectionI18NQuickFix.doFix(project, PluginXmlI18nInspection.getTags(Arrays.asList(descriptors)));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void doFix(@NotNull Project project, List<XmlTag> tags) {
            PluginXmlI18nInspection.choosePropertiesFileAndExtract(project, tags, selection -> {
                PropertiesFile propertiesFile = PluginXmlI18nInspection.findPropertiesFile(project, selection);
                if (propertiesFile != null) {
                    ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
                    psiFiles.add(propertiesFile.getContainingFile());
                    for (XmlTag tag : tags) {
                        psiFiles.add(tag.getContainingFile());
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)DevKitI18nBundle.message("inspections.plugin.xml.i18n.inspection.tag.command.name", "displayName"), null, () -> {
                        for (XmlTag tag : tags) {
                            InspectionI18NQuickFix.registerPropertyKey(project, tag, propertiesFile);
                        }
                    }, (PsiFile[])psiFiles.toArray(PsiFile.EMPTY_ARRAY));
                }
            });
        }

        private static void registerPropertyKey(@NotNull Project project, XmlTag xml, PropertiesFile propertiesFile) {
            String displayName = xml.getAttributeValue("displayName");
            if (displayName == null) {
                return;
            }
            xml.setAttribute("displayName", null);
            String shortName = xml.getAttributeValue("shortName");
            if (shortName == null) {
                String implementationClass = xml.getAttributeValue("implementationClass");
                if (implementationClass == null) {
                    return;
                }
                shortName = InspectionProfileEntry.getShortName((String)StringUtil.getShortName((String)implementationClass));
            }
            @NonNls String key = "inspection." + StringUtil.join((Object[])NameUtilCore.splitNameIntoWords((String)shortName), s -> StringUtil.decapitalize((String)s), (String)".") + ".display.name";
            xml.setAttribute("key", key);
            XmlTag rootTag = ((XmlFile)xml.getContainingFile()).getRootTag();
            XmlTag resourceBundle = rootTag != null ? rootTag.findFirstSubTag("resource-bundle") : null;
            String bundleQName = PluginXmlI18nInspection.getBundleQName(project, propertiesFile);
            if (resourceBundle == null || !bundleQName.equals(resourceBundle.getValue().getTrimmedText())) {
                xml.setAttribute("bundle", bundleQName);
            }
            JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile), key, StringUtil.unescapeXmlEntities((String)displayName), new UExpression[0]);
        }
    }
}

