/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.gradle;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.gradle.DevKitGradleBundle;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.KotlinDslGradleFrameworkSupportProvider;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;

public class GradleIntellijPluginFrameworkSupportProvider
extends KotlinDslGradleFrameworkSupportProvider {
    @NonNls
    private static final String ID = "gradle-intellij-plugin";
    private static final Logger LOG = Logger.getInstance(GradleIntellijPluginFrameworkSupportProvider.class);
    @NonNls
    private static final String LATEST_GRADLE_VERSION_KEY = "LATEST_GRADLE_VERSION_KEY";
    @NonNls
    private static final String LATEST_UPDATING_TIME_KEY = "LATEST_UPDATING_TIME_KEY";
    @NonNls
    private static final String FALLBACK_VERSION = "1.0";
    @NonNls
    protected static final String HELP_COMMENT = "// See https://github.com/JetBrains/gradle-intellij-plugin/\n";
    @NonNls
    private static final String TASK_NAME_RUN_IDE = ":runIde";
    @NonNls
    private static final String META_INF_PATH = "/src/main/resources/META-INF";

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return new FrameworkTypeEx(ID){

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                return GradleIntellijPluginFrameworkSupportProvider.this;
            }

            @NotNull
            public String getPresentableName() {
                return DevKitGradleBundle.message("module.wizard.gradle.presentable.name", new Object[0]);
            }

            @NotNull
            public Icon getIcon() {
                return AllIcons.Nodes.Plugin;
            }
        };
    }

    public void addSupport(@NotNull ProjectId projectId, @NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        BuildNumber build;
        String pluginVersion = PropertiesComponent.getInstance().getValue(LATEST_GRADLE_VERSION_KEY, FALLBACK_VERSION);
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        Object ideVersion = applicationInfo.isEAP() ? ((build = applicationInfo.getBuild()).isSnapshot() ? build.getBaselineVersion() + "-SNAPSHOT" : build.asStringWithoutProductCode()) : applicationInfo.getFullVersion();
        this.configureBuildScript(buildScriptData, pluginVersion, (String)ideVersion);
        VirtualFile contentRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
        if (contentRoot == null) {
            return;
        }
        if (!this.createPluginXml(projectId, module, contentRoot.getPath())) {
            return;
        }
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> {
            FileEditorManager.getInstance((Project)module.getProject()).openFile(buildScriptData.getBuildScriptFile(), true);
            GradleIntellijPluginFrameworkSupportProvider.createRunConfiguration(module, contentRoot.getPath());
        });
    }

    protected void configureBuildScript(@NotNull BuildScriptDataBuilder buildScriptData, @NonNls String pluginVersion, @NonNls String ideVersion) {
        buildScriptData.addPluginDefinitionInPluginsGroup("id 'org.jetbrains.intellij' version '" + pluginVersion + "'").addOther("// See https://github.com/JetBrains/gradle-intellij-plugin/\nintellij {\n    version = '" + ideVersion + "'\n}\n").addOther("patchPluginXml {\n    changeNotes = \"\"\"\n      Add change notes here.<br>\n      <em>most HTML tags may be used</em>\"\"\"\n}");
    }

    public JComponent createComponent() {
        String latestVersion = PropertiesComponent.getInstance().getValue(LATEST_GRADLE_VERSION_KEY);
        long timeCheck = PropertiesComponent.getInstance().getLong(LATEST_UPDATING_TIME_KEY, System.currentTimeMillis());
        if (latestVersion == null || TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - timeCheck) >= 1L) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            Lazy.EXECUTOR.execute(() -> {
                try {
                    String content = HttpRequests.request((String)"https://plugins.gradle.org/plugin/org.jetbrains.intellij").productNameAsUserAgent().readString((ProgressIndicator)new EmptyProgressIndicator(modalityState));
                    Matcher matcher = Pattern.compile("Version ([\\d.]+) \\(latest\\)").matcher(content);
                    if (matcher.find()) {
                        PropertiesComponent.getInstance().setValue(LATEST_GRADLE_VERSION_KEY, matcher.group(1));
                        PropertiesComponent.getInstance().setValue(LATEST_UPDATING_TIME_KEY, String.valueOf(System.currentTimeMillis()));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        HyperlinkLabel linkLabel = new HyperlinkLabel();
        linkLabel.setHtmlText(DevKitGradleBundle.message("module.wizard.gradle.learn.title", new Object[0]));
        linkLabel.setHyperlinkTarget("https://plugins.jetbrains.com/docs/intellij/developing-plugins.html?from=DevkitGradleProjectWizard");
        return linkLabel;
    }

    private boolean createPluginXml(@NotNull ProjectId projectId, @NotNull Module module, @NotNull String contentRootPath) {
        try {
            VirtualFile metaInf = VfsUtil.createDirectoryIfMissing((String)(contentRootPath + META_INF_PATH));
            if (metaInf == null) {
                return false;
            }
            if (metaInf.findChild("plugin.xml") != null) {
                return true;
            }
            Project project = module.getProject();
            VirtualFile pluginXml = metaInf.createChildData((Object)this, "plugin.xml");
            FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
            FileTemplate template = templateManager.getJ2eeTemplate("gradleBasedPlugin.xml");
            @NonNls HashMap<String, Object> attributes = new HashMap<String, Object>();
            String groupId = projectId.getGroupId();
            String artifactId = projectId.getArtifactId();
            if (StringUtil.isNotEmpty((String)artifactId)) {
                attributes.put("PLUGIN_ID", StringUtil.isNotEmpty((String)groupId) ? groupId + "." + artifactId : artifactId);
            } else {
                attributes.put("PLUGIN_ID", project.getName());
            }
            VfsUtil.saveText((VirtualFile)pluginXml, (String)template.getText(attributes));
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> FileEditorManager.getInstance((Project)project).openFile(pluginXml, true));
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private static void createRunConfiguration(@NotNull Module module, @NotNull String contentRootPath) {
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        ConfigurationFactory configurationFactory = new GradleExternalTaskConfigurationType().getConfigurationFactories()[0];
        String configurationName = DevKitBundle.message("run.configuration.title", new Object[0]);
        RunnerAndConfigurationSettings configuration = runManager.createConfiguration(configurationName, configurationFactory);
        RunConfiguration runConfiguration = configuration.getConfiguration();
        if (runConfiguration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemTaskExecutionSettings settings = ((ExternalSystemRunConfiguration)runConfiguration).getSettings();
            settings.setTaskNames(Collections.singletonList(TASK_NAME_RUN_IDE));
            settings.setExternalProjectPath(contentRootPath);
        }
        runManager.addConfiguration(configuration);
        runManager.setSelectedConfiguration(configuration);
    }

    private static final class Lazy {
        static final ExecutorService EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"UPDATE_GRADLE_PLUGIN_VERSIONS");

        private Lazy() {
        }
    }
}

