/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class PluginXmlIndexBase<K, V>
extends FileBasedIndexExtension<K, V> {
    PluginXmlIndexBase() {
    }

    protected abstract Map<K, V> performIndexing(IdeaPlugin var1);

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE});
    }

    @NotNull
    public DataIndexer<K, V, FileContent> getIndexer() {
        return new DataIndexer<K, V, FileContent>(){

            @NotNull
            public Map<K, V> map(@NotNull FileContent inputData) {
                IdeaPlugin plugin = PluginXmlIndexBase.obtainIdeaPlugin(inputData);
                if (plugin == null) {
                    return Collections.emptyMap();
                }
                return PluginXmlIndexBase.this.performIndexing(plugin);
            }
        };
    }

    protected static List<? extends DomElement> getChildrenWithoutIncludes(DomElement parent, @NonNls String tagName) {
        AbstractCollectionChildDescription collectionChildDescription = (AbstractCollectionChildDescription)parent.getGenericInfo().getCollectionChildDescription(tagName);
        DomInvocationHandler handler = Objects.requireNonNull(DomManagerImpl.getDomInvocationHandler((DomElement)parent));
        return handler.getCollectionChildren(collectionChildDescription, false);
    }

    @Nullable
    private static IdeaPlugin obtainIdeaPlugin(@NotNull FileContent content) {
        if (!PluginXmlIndexBase.looksLikeIdeaPluginXml(content)) {
            return null;
        }
        PsiFile file = content.getPsiFile();
        if (!(file instanceof XmlFile)) {
            return null;
        }
        return DescriptorUtil.getIdeaPlugin((XmlFile)file);
    }

    private static boolean looksLikeIdeaPluginXml(@NotNull FileContent content) {
        CharSequence text2 = content.getContentAsText();
        int idx = 0;
        while (true) {
            if ((idx = CharArrayUtil.indexOf((CharSequence)text2, (CharSequence)"<", (int)idx)) == -1) {
                return false;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)text2, (int)idx, (CharSequence)"<!--") && !CharArrayUtil.regionMatches((CharSequence)text2, (int)idx, (CharSequence)"<?")) break;
            ++idx;
        }
        return CharArrayUtil.regionMatches((CharSequence)text2, (int)idx, (CharSequence)"<idea-plugin");
    }
}

