/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.PluginModule;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PluginIdModuleIndex
extends PluginXmlIndexBase<String, Void> {
    private static final ID<String, Void> NAME = ID.create((String)"PluginIdModuleIndex");

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        return VoidDataExternalizer.INSTANCE;
    }

    @Override
    protected Map<String, Void> performIndexing(IdeaPlugin plugin) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(StringUtil.notNullize((String)plugin.getPluginId()));
        for (DomElement module : PluginIdModuleIndex.getChildrenWithoutIncludes(plugin, "module")) {
            ContainerUtil.addIfNotNull(ids, (Object)((PluginModule)module).getValue().getStringValue());
        }
        return ContainerUtil.newHashMap(ids, Collections.nCopies(ids.size(), null));
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    public int getVersion() {
        return 2;
    }

    public static Collection<VirtualFile> getFiles(@NotNull Project project, @NotNull String idOrModule) {
        GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project).union((SearchScope)LibraryScopeCache.getInstance((Project)project).getLibrariesOnlyScope());
        return FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)idOrModule, scope);
    }

    public static List<IdeaPlugin> findPlugins(@NotNull DomElement place, @NotNull String idOrModule) {
        Project project = place.getManager().getProject();
        Collection<VirtualFile> vFiles = PluginIdModuleIndex.getFiles(project, idOrModule);
        return JBIterable.from(vFiles).map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0)).filter(XmlFile.class).map(DescriptorUtil::getIdeaPlugin).filter(Conditions.notNull()).toList();
    }
}

