/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ContentDescriptor;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.DependencyDescriptor;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.PluginXmlIndexBase;

public final class PluginIdDependenciesIndex
extends PluginXmlIndexBase<String, Void> {
    private static final ID<String, Void> NAME = ID.create((String)"PluginIdDependenciesIndex");
    @NonNls
    private static final String FILENAME_KEY_PREFIX = "___FILENAME___";
    @NonNls
    private static final String PLUGIN_ID_KEY_PREFIX = "___PLUGIN_ID___";
    @NonNls
    private static final String CONTENT_KEY_PREFIX = "___CONTENT_ID___";

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public ID<String, Void> getName() {
        return NAME;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        return VoidDataExternalizer.INSTANCE;
    }

    @Override
    protected Map<String, Void> performIndexing(IdeaPlugin plugin) {
        SmartList ids = new SmartList();
        String pluginId = plugin.getPluginId();
        if (pluginId != null) {
            ids.add(PLUGIN_ID_KEY_PREFIX + pluginId);
        }
        List<DomElement> dependencies = PluginIdDependenciesIndex.getChildrenWithoutIncludes(plugin, "depends");
        for (Dependency dependency : dependencies) {
            ContainerUtil.addIfNotNull((Collection)ids, (Object)dependency.getStringValue());
            String configFile = dependency.getConfigFile().getStringValue();
            if (configFile == null) continue;
            String filename = PathUtil.getFileName((String)configFile);
            ids.add(PluginIdDependenciesIndex.getDependsIndexingKey(filename));
        }
        DependencyDescriptor dependencyDescriptor = plugin.getDependencies();
        for (DependencyDescriptor.PluginDescriptor pluginDescriptor : dependencyDescriptor.getPlugin()) {
            ContainerUtil.addIfNotNull((Collection)ids, (Object)pluginDescriptor.getId().getStringValue());
        }
        for (ContentDescriptor.ModuleDescriptor moduleDescriptor : dependencyDescriptor.getModuleEntry()) {
            ContainerUtil.addIfNotNull((Collection)ids, (Object)moduleDescriptor.getName().getStringValue());
        }
        for (ContentDescriptor.ModuleDescriptor descriptor : plugin.getContent().getModuleEntry()) {
            String value = descriptor.getName().getStringValue();
            if (!StringUtil.isNotEmpty((String)value)) continue;
            String escapeSubDescriptorValue = value.replace('/', '.');
            ids.add(PluginIdDependenciesIndex.getContentIndexingKey(escapeSubDescriptorValue));
        }
        return ContainerUtil.newHashMap((List)ids, Collections.nCopies(ids.size(), null));
    }

    public int getVersion() {
        return 5;
    }

    public static Set<String> getPluginAndDependsIds(Project project, Set<VirtualFile> files) {
        HashSet<String> ids = new HashSet<String>();
        for (VirtualFile file : files) {
            Set<String> keys = FileBasedIndex.getInstance().getFileData(NAME, file, project).keySet();
            String pluginId = PluginIdDependenciesIndex.findPluginId(keys);
            ContainerUtil.addIfNotNull(ids, (Object)pluginId);
            ids.addAll(ContainerUtil.filter(keys, s -> !StringUtil.startsWith((CharSequence)s, (CharSequence)PLUGIN_ID_KEY_PREFIX) && !StringUtil.startsWith((CharSequence)s, (CharSequence)FILENAME_KEY_PREFIX)));
        }
        return ids;
    }

    @Nullable
    @NlsSafe
    public static String getPluginId(Project project, VirtualFile file) {
        Set<String> keys = FileBasedIndex.getInstance().getFileData(NAME, file, project).keySet();
        return PluginIdDependenciesIndex.findPluginId(keys);
    }

    @Nullable
    private static String findPluginId(Set<String> data) {
        String pluginIdEntry = (String)ContainerUtil.find(data, s -> StringUtil.startsWith((CharSequence)s, (CharSequence)PLUGIN_ID_KEY_PREFIX));
        return pluginIdEntry == null ? null : StringUtil.trimStart((String)pluginIdEntry, (String)PLUGIN_ID_KEY_PREFIX);
    }

    public static Collection<VirtualFile> findDependsTo(Project project, VirtualFile file) {
        Collection dependsFiles = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)PluginIdDependenciesIndex.getDependsIndexingKey(file.getName()), GlobalSearchScopesCore.projectProductionScope((Project)project));
        Collection contentFiles = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)PluginIdDependenciesIndex.getContentIndexingKey(file.getNameWithoutExtension()), GlobalSearchScopesCore.projectProductionScope((Project)project));
        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>(dependsFiles);
        allFiles.addAll(contentFiles);
        return allFiles;
    }

    private static String getDependsIndexingKey(@NotNull String filename) {
        return FILENAME_KEY_PREFIX + filename;
    }

    private static String getContentIndexingKey(@NotNull String value) {
        return CONTENT_KEY_PREFIX + value;
    }
}

