/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.impl.LanguageResolvingUtil;

class LanguageResolvingConverter
extends ResolvingConverter<LanguageResolvingUtil.LanguageDefinition> {
    LanguageResolvingConverter() {
    }

    @NotNull
    public Collection<LanguageResolvingUtil.LanguageDefinition> getVariants(ConvertContext context) {
        return LanguageResolvingUtil.getAllLanguageDefinitions(context);
    }

    @Nullable
    public LookupElement createLookupElement(LanguageResolvingUtil.LanguageDefinition o) {
        String displayName = o.displayName.get();
        return LookupElementBuilder.create((Object)o.clazz, (String)o.id).withIcon(o.icon).withTailText(displayName == null ? null : " (" + displayName + ")").withTypeText(o.type, true);
    }

    @Nullable
    public LanguageResolvingUtil.LanguageDefinition fromString(@Nullable @NonNls String s, ConvertContext context) {
        Ref result = new Ref();
        LanguageResolvingUtil.processAllLanguageDefinitions(context, (Processor<? super LanguageResolvingUtil.LanguageDefinition>)((Processor)definition -> {
            if (definition.id.equals(s)) {
                result.set(definition);
                return false;
            }
            return true;
        }));
        return (LanguageResolvingUtil.LanguageDefinition)result.get();
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable LanguageResolvingUtil.LanguageDefinition resolvedValue) {
        return resolvedValue != null ? resolvedValue.clazz : null;
    }

    @Nullable
    public String toString(@Nullable LanguageResolvingUtil.LanguageDefinition o, ConvertContext context) {
        return o != null ? o.id : null;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return DevKitBundle.message("plugin.xml.convert.language.id.cannot.resolve", s);
    }
}

