/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ReferenceSetBase;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocator;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;

public final class ExtensionOrderConverter
implements CustomReferenceConverter<String> {
    private static final Logger LOG = Logger.getInstance(ExtensionOrderConverter.class);

    public PsiReference @NotNull [] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        PsiElement originalElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        final String orderValue = ElementManipulators.getValueText((PsiElement)originalElement);
        if (StringUtil.isEmpty((String)orderValue)) {
            return PsiReference.EMPTY_ARRAY;
        }
        final Extension extension = (Extension)value.getParentOfType(Extension.class, false);
        if (extension == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new ReferenceSetBase<PsiReference>(orderValue, element, 0, ','){

            protected List<PsiReference> createReferences(TextRange range, int index) {
                String orderPart = range.substring(orderValue);
                range = new TextRange(range.getStartOffset() + 1, range.getEndOffset() + 1);
                List<String> subParts = ExtensionOrderConverter.splitOrderPart(orderPart);
                if (subParts.isEmpty()) {
                    return Collections.emptyList();
                }
                String idSubPart = null;
                if (subParts.size() == 2) {
                    idSubPart = subParts.get(1);
                } else if (ExtensionOrderConverter.isBeforeOrAfterKeyword(StringUtil.trimLeading((String)orderPart), false)) {
                    idSubPart = "";
                }
                if (subParts.size() > 2 || idSubPart != null && !ExtensionOrderConverter.isBeforeOrAfterKeyword(subParts.get(0))) {
                    return Collections.singletonList(new InvalidOrderPartPsiReference(this.getElement(), range, orderPart));
                }
                List<TextRange> wordIndices = ExtensionOrderConverter.getWordIndicesInOrderPart(orderPart);
                if (wordIndices.isEmpty()) {
                    LOG.error("Unexpected empty word indices list for 'order' part: " + orderPart);
                    return Collections.singletonList(new InvalidOrderPartPsiReference(this.getElement(), range, orderPart));
                }
                if (idSubPart != null && idSubPart.isEmpty()) {
                    wordIndices.add(new TextRange(orderPart.length(), orderPart.length()));
                }
                if (idSubPart == null) {
                    return Collections.emptyList();
                }
                assert (wordIndices.size() == 2) : wordIndices.toString();
                TextRange idSubPartRange = wordIndices.get(1).shiftRight(range.getStartOffset());
                return Collections.singletonList(new OrderReferencedIdPsiReference(this.getElement(), idSubPartRange, idSubPart, extension));
            }
        }.getPsiReferences();
    }

    private static List<String> splitOrderPart(String orderPart) {
        ArrayList<String> result = new ArrayList<String>();
        List subParts = StringUtil.split((String)orderPart, (String)" ");
        subParts.forEach(s -> {
            if (":".equals(s)) {
                result.add((String)s);
            } else {
                Collections.addAll(result, s.split(":"));
            }
        });
        return result;
    }

    private static List<TextRange> getWordIndicesInOrderPart(String orderPart) {
        return StringUtil.getWordIndicesIn((String)orderPart, Set.of(Character.valueOf(' '), Character.valueOf(':')));
    }

    private static boolean isBeforeOrAfterKeyword(String str) {
        return ExtensionOrderConverter.isBeforeOrAfterKeyword(str, true);
    }

    private static boolean isBeforeOrAfterKeyword(String str, boolean trimKeyword) {
        return (trimKeyword ? "before ".trim() : "before ").equalsIgnoreCase(str) || (trimKeyword ? "after ".trim() : "after ").equalsIgnoreCase(str) || "before:".equalsIgnoreCase(str) || "after:".equalsIgnoreCase(str);
    }

    private static class OrderReferencedIdPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myReferencedId;
        private final Extension myExtension;

        OrderReferencedIdPsiReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull String referencedId, @NotNull Extension extension) {
            super(element, rangeInElement);
            this.myReferencedId = referencedId;
            this.myExtension = extension;
        }

        @Nullable
        public PsiElement resolve() {
            ExtensionPoint extensionPoint = this.myExtension.getExtensionPoint();
            if (extensionPoint == null) {
                return null;
            }
            ExtensionLocator epAndIdLocator = ExtensionLocatorKt.locateExtensionsByExtensionPointAndId(extensionPoint, this.myReferencedId);
            List<ExtensionCandidate> candidates = epAndIdLocator.findCandidates();
            if (candidates.isEmpty()) {
                return null;
            }
            XmlTag referencedElement = (XmlTag)candidates.iterator().next().pointer.getElement();
            if (referencedElement == null) {
                return null;
            }
            DomManager domManager = DomManager.getDomManager((Project)referencedElement.getProject());
            DomElement domElement = domManager.getDomElement(referencedElement);
            if (domElement == null) {
                return referencedElement;
            }
            DomTarget target = DomTarget.getTarget((DomElement)domElement);
            if (target == null) {
                return referencedElement;
            }
            return PomService.convertToPsi((PsiTarget)target);
        }

        public Object @NotNull [] getVariants() {
            ExtensionPoint extensionPoint = this.myExtension.getExtensionPoint();
            if (extensionPoint == null) {
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            List<ExtensionCandidate> candidates = ExtensionLocatorKt.locateExtensionsByExtensionPoint(extensionPoint);
            Project project = this.getElement().getProject();
            DomManager domManager = DomManager.getDomManager((Project)project);
            ArrayList<Extension> extensionsForThisEp = new ArrayList<Extension>();
            for (ExtensionCandidate candidate : candidates) {
                XmlTag tag = (XmlTag)candidate.pointer.getElement();
                DomElement domElement = domManager.getDomElement(tag);
                if (!(domElement instanceof Extension)) continue;
                extensionsForThisEp.add((Extension)domElement);
            }
            Map<Extension, String> targetExtensionsWithMarks = this.filterAndMarkExtensions(extensionsForThisEp, project);
            List<LookupElement> idCompletionVariants = OrderReferencedIdPsiReference.getLookupElements(targetExtensionsWithMarks);
            return idCompletionVariants.toArray(LookupElement.EMPTY_ARRAY);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            ExtensionPoint ep = this.myExtension.getExtensionPoint();
            String epFqn = ep != null ? ep.getEffectiveQualifiedName() + " " : "";
            return DevKitBundle.message("plugin.xml.convert.extension.order.cannot.resolve", epFqn);
        }

        public boolean isSoft() {
            return true;
        }

        private Map<Extension, String> filterAndMarkExtensions(List<Extension> extensionsForThisEp, Project project) {
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            GlobalSearchScope resolveScope = this.getElement().getResolveScope();
            PsiClass languageEpClass = javaPsiFacade.findClass(LanguageExtensionPoint.class.getCanonicalName(), resolveScope);
            if (languageEpClass == null) {
                return Collections.emptyMap();
            }
            PsiClass fileTypeEpClass = javaPsiFacade.findClass(FileTypeExtensionPoint.class.getCanonicalName(), resolveScope);
            if (fileTypeEpClass == null) {
                return Collections.emptyMap();
            }
            String currentExtensionId = this.myExtension.getId().getStringValue();
            String currentExtensionLanguage = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(this.myExtension, languageEpClass, "language");
            String currentExtensionFileType = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(this.myExtension, fileTypeEpClass, "filetype");
            HashMap<Extension, String> result = new HashMap<Extension, String>();
            for (Extension extension : extensionsForThisEp) {
                String fileType;
                String language;
                String id = extension.getId().getStringValue();
                if (StringUtil.isEmpty((String)id) || id.equals(currentExtensionId)) continue;
                String extensionMark = null;
                if (currentExtensionLanguage != null && (language = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(extension, languageEpClass, "language")) != null) {
                    if (!language.equals("any") && !language.isEmpty() && !language.equals(currentExtensionLanguage)) continue;
                    extensionMark = language;
                }
                if (currentExtensionFileType != null && (fileType = OrderReferencedIdPsiReference.getSpecificExtensionAttribute(extension, fileTypeEpClass, "filetype")) != null) {
                    if (!currentExtensionFileType.equals(fileType)) continue;
                    extensionMark = extensionMark != null ? null : fileType;
                }
                result.put(extension, extensionMark);
            }
            return result;
        }

        @NotNull
        private static List<LookupElement> getLookupElements(@NotNull Map<Extension, String> targetExtensionsWithMarks) {
            ArrayList<LookupElement> result = new ArrayList<LookupElement>(targetExtensionsWithMarks.size());
            for (Map.Entry<Extension, String> entry : targetExtensionsWithMarks.entrySet()) {
                Extension extension = entry.getKey();
                String mark = entry.getValue();
                PsiElement targetElement = OrderReferencedIdPsiReference.getTargetElement(extension);
                String id = extension.getId().getStringValue();
                if (StringUtil.isEmpty((String)id)) {
                    LOG.error("Unexpected empty id in target extension: " + extension);
                    continue;
                }
                result.add(OrderReferencedIdPsiReference.createLookupElement(targetElement, id, extension.getModule(), mark));
            }
            return result;
        }

        @Nullable
        @NlsSafe
        private static String getSpecificExtensionAttribute(@NotNull Extension e, @NotNull PsiClass parentBeanClass, @NotNull @NonNls String attribute) {
            ExtensionPoint ep = e.getExtensionPoint();
            if (ep == null) {
                return null;
            }
            PsiClass beanClass = (PsiClass)ep.getBeanClass().getValue();
            if (beanClass == null) {
                return null;
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)parentBeanClass, (boolean)true)) {
                return null;
            }
            DomAttributeChildDescription attributeDescription = e.getGenericInfo().getAttributeChildDescription(attribute);
            if (attributeDescription == null) {
                return null;
            }
            return attributeDescription.getDomAttributeValue((DomElement)e).getStringValue();
        }

        @NotNull
        private static PsiElement getTargetElement(Extension e) {
            DomTarget extensionTarget = DomTarget.getTarget((DomElement)e);
            if (extensionTarget != null) {
                return PomService.convertToPsi((PsiTarget)extensionTarget);
            }
            return e.getXmlTag();
        }

        @NotNull
        private static LookupElement createLookupElement(@NotNull PsiElement targetElement, @NotNull String id, @Nullable Module module, @Nullable String mark) {
            LookupElementBuilder element = LookupElementBuilder.create((Object)targetElement, (String)id);
            if (module != null) {
                element = element.withTypeText(module.getName(), ModuleType.get((Module)module).getIcon(), false).withTypeIconRightAligned(true);
            }
            if (mark != null) {
                element = element.withTailText(" {" + mark + "}", true);
            }
            return element;
        }
    }

    private static class InvalidOrderPartPsiReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        private final String myOrderPart;

        InvalidOrderPartPsiReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, String orderPart) {
            super(element, rangeInElement);
            this.myOrderPart = orderPart;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return DevKitBundle.message("invalid.order.attribute.part", this.myOrderPart.trim());
        }

        public boolean isSoft() {
            return true;
        }
    }
}

