/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class DependencyConfigFileConverter
extends PathReferenceConverter {
    private static final PathReferenceProvider ourProvider = new StaticPathReferenceProvider(null){

        public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text2, @NotNull List<? super PsiReference> references, boolean soft) {
            FileReferenceSet set = new FileReferenceSet(text2, psiElement, offset, null, true, true, new FileType[]{XmlFileType.INSTANCE}){
                private final Condition<PsiFileSystemItem> PLUGIN_XML_CONDITION;
                {
                    this.PLUGIN_XML_CONDITION = item -> !item.isDirectory() && !item.equals(this.getContainingFile()) && item instanceof XmlFile && DescriptorUtil.isPluginXml((PsiFile)item) && !this.isAlreadyUsed((XmlFile)item);
                }

                private boolean isAlreadyUsed(XmlFile xmlFile) {
                    PsiFile file = this.getContainingFile();
                    if (!(file instanceof XmlFile)) {
                        return false;
                    }
                    IdeaPlugin ideaPlugin = DescriptorUtil.getIdeaPlugin((XmlFile)file);
                    if (ideaPlugin == null) {
                        return false;
                    }
                    return !ContainerUtil.process(ideaPlugin.getDepends(), dependency -> {
                        GenericAttributeValue<PathReference> configFileAttribute = dependency.getConfigFile();
                        if (!DomUtil.hasXml(configFileAttribute)) {
                            return true;
                        }
                        PathReference pathReference = (PathReference)configFileAttribute.getValue();
                        if (pathReference == null) {
                            return true;
                        }
                        return !xmlFile.equals(pathReference.resolve());
                    });
                }

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    PsiFile containingFile = this.getContainingFile();
                    if (containingFile == null) {
                        return Collections.emptyList();
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module == null) {
                        return Collections.emptyList();
                    }
                    HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
                    VirtualFile parent = containingFile.getVirtualFile().getParent();
                    roots.add(parent);
                    for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION)) {
                        roots.add(sourceRoot.findChild("META-INF"));
                    }
                    return this.toFileSystemItems(roots);
                }

                protected boolean isSoft() {
                    return true;
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return this.PLUGIN_XML_CONDITION;
                }
            };
            Collections.addAll(references, set.getAllReferences());
            return true;
        }
    };

    public PathReference fromString(@Nullable String s, ConvertContext context) {
        XmlElement element = context.getReferenceXmlElement();
        Module module = context.getModule();
        if (s == null || element == null || module == null) {
            return null;
        }
        return PathReferenceManager.getInstance().getCustomPathReference(s, module, (PsiElement)element, new PathReferenceProvider[]{ourProvider});
    }

    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        return PathReferenceManager.getInstance().createCustomReferences(psiElement, soft, new PathReferenceProvider[]{ourProvider});
    }
}

