/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewActionDialog;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class NewActionAction
extends CreateElementActionBase
implements DescriptorUtil.Patcher {
    private NewActionDialog myDialog;
    private XmlFile pluginDescriptorToPatch;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected final PsiElement @NotNull [] invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        PsiElement[] psiElements = this.doInvokeDialog(project, directory);
        return psiElements == Holder.CANCELED ? PsiElement.EMPTY_ARRAY : psiElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiElement[] doInvokeDialog(Project project, @NotNull PsiDirectory directory) {
        this.myDialog = new NewActionDialog(project, directory);
        try {
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                this.pluginDescriptorToPatch = DevkitActionsUtil.choosePluginModuleDescriptor(directory);
                if (this.pluginDescriptorToPatch != null) {
                    CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
                    validator.canClose(this.myDialog.getActionName());
                    PsiElement[] psiElementArray = validator.getCreatedElements();
                    return psiElementArray;
                }
            }
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            return psiElementArray;
        }
        finally {
            this.myDialog = null;
            this.pluginDescriptorToPatch = null;
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
        if (module == null || !PsiUtil.isPluginModule(module)) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, JavaCreateTemplateInPackageAction::doCheckPackageExists);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected PsiElement @NotNull [] create(@NotNull String newName, @NotNull PsiDirectory directory) throws Exception {
        PsiClass createdClass = DevkitActionsUtil.createSingleClass(newName, "Action.java", directory);
        DescriptorUtil.patchPluginXml(this, createdClass, this.pluginDescriptorToPatch);
        return new PsiElement[]{createdClass};
    }

    @Override
    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        ActionType.ACTION.patchPluginXml(pluginXml, klass, this.myDialog);
    }

    protected String getErrorTitle() {
        return DevKitBundle.message("new.action.error", new Object[0]);
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName) {
        return DevKitBundle.message("new.action.action.name", directory, newName);
    }

    private static class Holder {
        private static final PsiClass[] CANCELED = new PsiClass[1];

        private Holder() {
        }
    }
}

