/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.codegen;

import com.intellij.workspaceModel.codegen.InterfaceVisitor;
import com.intellij.workspaceModel.codegen.deft.Field;
import com.intellij.workspaceModel.codegen.deft.TBlob;
import com.intellij.workspaceModel.codegen.deft.TBoolean;
import com.intellij.workspaceModel.codegen.deft.TInt;
import com.intellij.workspaceModel.codegen.deft.TList;
import com.intellij.workspaceModel.codegen.deft.TMap;
import com.intellij.workspaceModel.codegen.deft.TOptional;
import com.intellij.workspaceModel.codegen.deft.TString;
import com.intellij.workspaceModel.codegen.deft.ValueType;
import com.intellij.workspaceModel.codegen.deft.model.DefType;
import com.intellij.workspaceModel.codegen.deft.model.KtInterfaceKind;
import com.intellij.workspaceModel.codegen.deft.model.WsData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\r\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J.\u0010\u0014\u001a\u00020\t2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/codegen/InterfaceTraverser;", "", "simpleTypes", "", "Lcom/intellij/workspaceModel/codegen/deft/model/DefType;", "(Ljava/util/List;)V", "getSimpleTypes", "()Ljava/util/List;", "traverse", "", "myInterface", "visitor", "Lcom/intellij/workspaceModel/codegen/InterfaceVisitor;", "traverseField", "field", "Lcom/intellij/workspaceModel/codegen/deft/Field;", "varName", "", "kind", "Lcom/intellij/workspaceModel/codegen/deft/model/KtInterfaceKind;", "traverseType", "type", "Lcom/intellij/workspaceModel/codegen/deft/ValueType;", "intellij.platform.workspaceModel.codegen"})
public final class InterfaceTraverser {
    @NotNull
    private final List<DefType> simpleTypes;

    public final boolean traverse(@NotNull DefType myInterface, @NotNull InterfaceVisitor visitor) {
        for (Field field : myInterface.getStructure().getDeclaredFields()) {
            boolean res = this.traverseField(field, visitor, field.getName(), myInterface.getDef().getKind());
            if (res) continue;
            return false;
        }
        return true;
    }

    private final boolean traverseField(Field<?, ?> field, InterfaceVisitor visitor, String varName, KtInterfaceKind kind2) {
        return this.traverseType(field.getType(), visitor, varName, kind2);
    }

    private final boolean traverseType(ValueType<?> type2, InterfaceVisitor visitor, String varName, KtInterfaceKind kind2) {
        ValueType<?> valueType = type2;
        if (valueType instanceof TBoolean) {
            return visitor.visitBoolean(varName);
        }
        if (valueType instanceof TInt) {
            return visitor.visitInt(varName);
        }
        if (valueType instanceof TString) {
            return visitor.visitString(varName);
        }
        if (valueType instanceof TList) {
            String itemVarName = "_" + varName;
            boolean shouldProcessList = visitor.visitListStart(varName, itemVarName, ((TList)type2).getElementType());
            if (!shouldProcessList) {
                return false;
            }
            boolean traversingResult = this.traverseType(((TList)type2).getElementType(), visitor, itemVarName, kind2);
            return visitor.visitListEnd(varName, itemVarName, traversingResult, ((TList)type2).getElementType());
        }
        if (valueType instanceof TMap) {
            String valueVarName;
            String keyVarName = "key_" + varName;
            boolean shouldProcessMap = visitor.visitMapStart(varName, keyVarName, valueVarName = "value_" + varName, ((TMap)type2).getKeyType(), ((TMap)type2).getValueType());
            if (!shouldProcessMap) {
                return false;
            }
            boolean keyTraverseResult = this.traverseType(((TMap)type2).getKeyType(), visitor, keyVarName, kind2);
            boolean valueTraverseResult = this.traverseType(((TMap)type2).getValueType(), visitor, valueVarName, kind2);
            return visitor.visitMapEnd(varName, keyVarName, valueVarName, ((TMap)type2).getKeyType(), ((TMap)type2).getValueType(), keyTraverseResult && valueTraverseResult);
        }
        if (valueType instanceof TOptional) {
            String notNullVarName = "_" + varName;
            boolean continueProcess = visitor.visitOptionalStart(varName, notNullVarName, ((TOptional)type2).getType());
            if (!continueProcess) {
                return false;
            }
            continueProcess = this.traverseType(((TOptional)type2).getType(), visitor, notNullVarName, kind2);
            return visitor.visitOptionalEnd(varName, notNullVarName, ((TOptional)type2).getType(), continueProcess);
        }
        if (valueType instanceof TBlob) {
            Object v0;
            block14: {
                Iterable continueProcess;
                Iterable iterable = continueProcess = (Iterable)this.simpleTypes;
                for (Object t : iterable) {
                    DefType it = (DefType)((Object)t);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((TBlob)type2).getJavaSimpleName())) continue;
                    v0 = t;
                    break block14;
                }
                v0 = null;
            }
            DefType foundType = v0;
            if (foundType == null) {
                return visitor.visitUnknownBlob(varName, ((TBlob)type2).getJavaSimpleName());
            }
            if (Intrinsics.areEqual((Object)kind2, (Object)WsData.INSTANCE)) {
                boolean process2 = visitor.visitDataClassStart(varName, ((TBlob)type2).getJavaSimpleName(), foundType);
                if (!process2) {
                    return false;
                }
                process2 = this.traverse(foundType, visitor);
                return visitor.visitDataClassEnd(varName, ((TBlob)type2).getJavaSimpleName(), process2, foundType);
            }
            return false;
        }
        return true;
    }

    @NotNull
    public final List<DefType> getSimpleTypes() {
        return this.simpleTypes;
    }

    public InterfaceTraverser(@NotNull List<DefType> simpleTypes) {
        this.simpleTypes = simpleTypes;
    }
}

