/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformLauncherWrapper;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"launchProcessWithFallback", "Ljava/lang/Process;", "processBuilder", "Ljava/lang/ProcessBuilder;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "reportingSource", "", "kotlin-daemon-client"})
public final class NativePlatformUtilKt {
    @NotNull
    public static final Process launchProcessWithFallback(@NotNull ProcessBuilder processBuilder, @NotNull DaemonReportingTargets reportingTargets, @NotNull String reportingSource) {
        Process process;
        Process process2;
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        Intrinsics.checkNotNullParameter((Object)reportingSource, (String)"reportingSource");
        try {
            process2 = new NativePlatformLauncherWrapper().launch(processBuilder);
        }
        catch (UnsatisfiedLinkError e) {
            KotlinCompilerClientKt.report(reportingTargets, DaemonReportCategory.DEBUG, "Could not start process with native process launcher, falling back to ProcessBuilder#start (" + e + ')', reportingSource);
            process2 = null;
        }
        catch (IOException e) {
            KotlinCompilerClientKt.report(reportingTargets, DaemonReportCategory.DEBUG, "Could not start process with native process launcher, falling back to ProcessBuilder#start (" + e.getCause() + ')', reportingSource);
            process2 = null;
        }
        catch (NoClassDefFoundError e) {
            KotlinCompilerClientKt.report(reportingTargets, DaemonReportCategory.DEBUG, "net.rubygrapefruit.platform library is not in the classpath, falling back to ProcessBuilder#start (" + e + ')', reportingSource);
            process2 = null;
        }
        catch (ClassNotFoundException e) {
            KotlinCompilerClientKt.report(reportingTargets, DaemonReportCategory.DEBUG, "net.rubygrapefruit.platform library is not in the classpath, falling back to ProcessBuilder#start (" + e + ')', reportingSource);
            process2 = null;
        }
        if ((process = process2) == null) {
            Process process3 = processBuilder.start();
            process = process3;
            Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"processBuilder.start()");
        }
        return process;
    }

    public static /* synthetic */ Process launchProcessWithFallback$default(ProcessBuilder processBuilder, DaemonReportingTargets daemonReportingTargets, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "process launcher";
        }
        return NativePlatformUtilKt.launchProcessWithFallback(processBuilder, daemonReportingTargets, string2);
    }
}

