/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Substitutable;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubstitutingScope
implements MemberScope {
    @NotNull
    private final MemberScope workerScope;
    @NotNull
    private final TypeSubstitutor substitutor;
    @Nullable
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors;
    @NotNull
    private final Lazy _allDescriptors$delegate;

    public SubstitutingScope(@NotNull MemberScope workerScope, @NotNull TypeSubstitutor givenSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)workerScope, (String)"workerScope");
        Intrinsics.checkNotNullParameter((Object)givenSubstitutor, (String)"givenSubstitutor");
        this.workerScope = workerScope;
        TypeSubstitution typeSubstitution = givenSubstitutor.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"givenSubstitutor.substitution");
        this.substitutor = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(typeSubstitution, false, 1, null).buildSubstitutor();
        this._allDescriptors$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Collection<? extends DeclarationDescriptor>>(this){
            final /* synthetic */ SubstitutingScope this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Collection<DeclarationDescriptor> invoke() {
                return SubstitutingScope.access$substitute(this.this$0, ResolutionScope.DefaultImpls.getContributedDescriptors$default(SubstitutingScope.access$getWorkerScope$p(this.this$0), null, null, 3, null));
            }
        }));
    }

    private final Collection<DeclarationDescriptor> get_allDescriptors() {
        Lazy lazy = this._allDescriptors$delegate;
        Object var2_2 = null;
        return (Collection)lazy.getValue();
    }

    private final <D extends DeclarationDescriptor> D substitute(D descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        if (this.substitutor.isEmpty()) {
            return descriptor2;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = new HashMap();
        }
        Map<DeclarationDescriptor, DeclarationDescriptor> map = this.substitutedDescriptors;
        Intrinsics.checkNotNull(map);
        Map<DeclarationDescriptor, DeclarationDescriptor> $this$getOrPut$iv = map;
        boolean $i$f$getOrPut = false;
        DeclarationDescriptor value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            Object t;
            boolean bl = false;
            D d = descriptor2;
            if (d instanceof Substitutable) {
                Object $this$sure$iv = ((Substitutable)((Object)descriptor2)).substitute(this.substitutor);
                boolean $i$f$sure = false;
                t = $this$sure$iv;
                if (t == null) {
                    String string2;
                    boolean bl2 = false;
                    String string3 = string2 = "We expect that no conflict should happen while substitution is guaranteed to generate invariant projection, but " + descriptor2 + " substitution fails";
                    throw new AssertionError((Object)string3);
                }
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown descriptor in scope: ", descriptor2).toString());
            }
            DeclarationDescriptor answer$iv = (DeclarationDescriptor)t;
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            declarationDescriptor = answer$iv;
        } else {
            declarationDescriptor = value$iv;
        }
        DeclarationDescriptor substituted = declarationDescriptor;
        return (D)substituted;
    }

    private final <D extends DeclarationDescriptor> Collection<D> substitute(Collection<? extends D> descriptors) {
        if (this.substitutor.isEmpty()) {
            return descriptors;
        }
        if (descriptors.isEmpty()) {
            return descriptors;
        }
        LinkedHashSet<DeclarationDescriptor> result2 = CollectionsKt.newLinkedHashSetWithExpectedSize(descriptors.size());
        for (DeclarationDescriptor descriptor2 : descriptors) {
            DeclarationDescriptor substitute = this.substitute(descriptor2);
            result2.add(substitute);
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<? extends PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.substitute(this.workerScope.getContributedVariables(name, location));
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ClassifierDescriptor classifierDescriptor2 = this.workerScope.getContributedClassifier(name, location);
        if (classifierDescriptor2 == null) {
            classifierDescriptor = null;
        } else {
            ClassifierDescriptor classifierDescriptor3;
            ClassifierDescriptor it = classifierDescriptor3 = classifierDescriptor2;
            boolean bl = false;
            classifierDescriptor = (ClassifierDescriptor)this.substitute((DeclarationDescriptor)it);
        }
        return classifierDescriptor;
    }

    @Override
    @NotNull
    public Collection<? extends SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.substitute(this.workerScope.getContributedFunctions(name, location));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        return this.get_allDescriptors();
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return this.workerScope.getFunctionNames();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return this.workerScope.getVariableNames();
    }

    @Override
    @Nullable
    public Set<Name> getClassifierNames() {
        return this.workerScope.getClassifierNames();
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        MemberScope.DefaultImpls.recordLookup(this, name, location);
    }

    public static final /* synthetic */ Collection access$substitute(SubstitutingScope $this, Collection descriptors) {
        return $this.substitute(descriptors);
    }

    public static final /* synthetic */ MemberScope access$getWorkerScope$p(SubstitutingScope $this) {
        return $this.workerScope;
    }
}

