/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.DetachedToolWindow;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachedToolWindowManager
implements Disposable {
    private final Application myApplication = ApplicationManager.getApplication();
    private final Project myProject;
    private final MyFileEditorManagerListener myEditorManagerListener;
    private final Map<FileEditor, WorkBench<?>> myWorkBenchMap;
    private final Map<String, DetachedToolWindow<?>> myToolWindowMap;
    private DetachedToolWindowFactory myDetachedToolWindowFactory;
    private FileEditor myLastSelectedEditor;

    public static DetachedToolWindowManager getInstance(@NotNull Project project) {
        return (DetachedToolWindowManager)project.getService(DetachedToolWindowManager.class);
    }

    @VisibleForTesting
    DetachedToolWindowManager(@NotNull Project currentProject) {
        this.myProject = currentProject;
        this.myEditorManagerListener = new MyFileEditorManagerListener();
        this.myWorkBenchMap = new IdentityHashMap(13);
        this.myToolWindowMap = new HashMap(8);
        this.myDetachedToolWindowFactory = DetachedToolWindow::new;
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myEditorManagerListener);
    }

    @VisibleForTesting
    void setDetachedToolWindowFactory(@NotNull DetachedToolWindowFactory factory) {
        this.myDetachedToolWindowFactory = factory;
    }

    @VisibleForTesting
    FileEditorManagerListener getFileEditorManagerListener() {
        return this.myEditorManagerListener;
    }

    public void register(@Nullable FileEditor fileEditor, @NotNull WorkBench<?> workBench) {
        if (fileEditor != null) {
            this.myWorkBenchMap.put(fileEditor, workBench);
            if (fileEditor == this.myLastSelectedEditor) {
                this.updateToolWindowsForWorkBench(workBench);
            }
        }
    }

    public void unregister(@Nullable FileEditor fileEditor) {
        if (fileEditor != null) {
            this.myWorkBenchMap.remove(fileEditor);
        }
    }

    public void dispose() {
        for (DetachedToolWindow<?> detachedToolWindow : this.myToolWindowMap.values()) {
            detachedToolWindow.updateSettingsInAttachedToolWindow();
        }
    }

    @Nullable
    private WorkBench getActiveWorkBench() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof WorkBench) {
            return (WorkBench)((Object)focusOwner);
        }
        WorkBench current = (WorkBench)((Object)SwingUtilities.getAncestorOfClass(WorkBench.class, focusOwner));
        if (current != null) {
            return current;
        }
        FileEditor[] selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors();
        if (selectedEditors.length == 0) {
            return null;
        }
        if (selectedEditors.length == 1) {
            return this.myWorkBenchMap.get(selectedEditors[0]);
        }
        if (focusOwner != null) {
            for (FileEditor editor : selectedEditors) {
                if (!SwingUtilities.isDescendingFrom(focusOwner, editor.getComponent())) continue;
                return this.myWorkBenchMap.get(editor);
            }
        }
        return this.myWorkBenchMap.get(selectedEditors[0]);
    }

    public void updateToolWindowsForWorkBench(@Nullable WorkBench workBench) {
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>(this.myToolWindowMap.keySet());
        if (workBench != null) {
            String workBenchPrefix = workBench.getName() + ".";
            List detachedToolWindows = workBench.getDetachedToolWindows();
            for (AttachedToolWindow tool : detachedToolWindows) {
                ToolWindowDefinition definition = tool.getDefinition();
                String id2 = workBenchPrefix + definition.getName();
                DetachedToolWindow detachedToolWindow = this.myToolWindowMap.get(id2);
                if (detachedToolWindow == null) {
                    String workBenchName = DetachedToolWindowManager.getWorkBenchTitleName(workBench);
                    detachedToolWindow = this.myDetachedToolWindowFactory.create(this.myProject, workBenchName, definition);
                    Disposer.register((Disposable)this.myProject, (Disposable)detachedToolWindow);
                    this.myToolWindowMap.put(id2, detachedToolWindow);
                }
                if (!ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled()) {
                    detachedToolWindow.show(tool);
                }
                ids.remove(id2);
            }
        }
        ids.forEach(id -> this.myToolWindowMap.get(id).hide());
    }

    public void restoreDefaultLayout() {
        this.myApplication.invokeLater(() -> this.updateToolWindowsForWorkBench(this.getActiveWorkBench()));
    }

    @NotNull
    private static String getWorkBenchTitleName(@NotNull WorkBench workBench) {
        switch (workBench.getName()) {
            case "NELE_EDITOR": {
                return "Designer";
            }
            case "NAV_EDITOR": {
                return "Navigation";
            }
        }
        return workBench.getName();
    }

    static interface DetachedToolWindowFactory {
        public DetachedToolWindow create(@NotNull Project var1, @NotNull String var2, @NotNull ToolWindowDefinition var3);
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            DetachedToolWindowManager.this.myLastSelectedEditor = event.getNewEditor();
            DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.myWorkBenchMap.get(DetachedToolWindowManager.this.myLastSelectedEditor));
        }
    }
}

