/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionToolbarUtil {
    private ActionToolbarUtil() {
    }

    public static void makeToolbarNavigable(@NotNull ActionToolbar toolbar) {
        if (!ScreenReader.isActive()) {
            Arrays.stream(toolbar.getComponent().getComponents()).forEach(ActionToolbarUtil::makeActionNavigable);
            toolbar.getComponent().addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(@NotNull ContainerEvent event) {
                    ActionToolbarUtil.makeActionNavigable(event.getChild());
                }

                @Override
                public void componentRemoved(@NotNull ContainerEvent event) {
                }
            });
        }
    }

    private static void makeActionNavigable(@NotNull Component child) {
        if (child instanceof ActionButton || child instanceof JCheckBox) {
            child.setFocusable(true);
        }
    }

    @Nullable
    public static ActionButton findActionButton(@NotNull ActionToolbar toolbar, @NotNull AnAction action) {
        return Arrays.stream(toolbar.getComponent().getComponents()).filter(child -> child instanceof ActionButton && ((ActionButton)child).getAction().equals(action)).findFirst().orElse(null);
    }
}

