/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import sun.swing.MenuItemLayoutHelper;

public class CommonMenuLayoutHelper
extends MenuItemLayoutHelper {
    private int myLeadingGap;
    private int myCheckedIconGap;

    public CommonMenuLayoutHelper(JMenuItem menuItem, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int textIconGap, int leadingGap, int checkedIconGap, String acceleratorDelimiter, boolean isLeftToRight, Font menuFont, Font acceleratorFont, boolean useCheckAndArrow, String propertyPrefix) {
        super(menuItem, checkIcon, arrowIcon, viewRect, textIconGap, acceleratorDelimiter, isLeftToRight, menuFont, acceleratorFont, useCheckAndArrow, propertyPrefix);
        this.myLeadingGap = leadingGap;
        this.myCheckedIconGap = checkedIconGap;
    }

    @Override
    public int getLeadingGap() {
        return this.myLeadingGap;
    }

    @Override
    public int getAfterCheckIconGap() {
        return this.myCheckedIconGap;
    }

    @Override
    public MenuItemLayoutHelper.LayoutResult layoutMenuItem() {
        MenuItemLayoutHelper.LayoutResult result = super.layoutMenuItem();
        if (this.isLeftToRight()) {
            this.doLTRColumnLayout(result, this.getLTRColumnAlignment());
        } else {
            this.doRTLColumnLayout(result, this.getRTLColumnAlignment());
        }
        return result;
    }

    private void doLTRColumnLayout(MenuItemLayoutHelper.LayoutResult layoutResult, MenuItemLayoutHelper.ColumnAlignment columnAlignment) {
        layoutResult.getIconRect().width = this.getIconSize().getMaxWidth();
        layoutResult.getTextRect().width = this.getTextSize().getMaxWidth();
        this.calcXPositionsLTR(this.getViewRect().x, this.getLeadingGap(), this.getGap(), layoutResult.getCheckRect(), layoutResult.getIconRect(), layoutResult.getTextRect());
        if (layoutResult.getCheckRect().width > 0) {
            Rectangle tmp = layoutResult.getIconRect();
            tmp.x += this.getAfterCheckIconGap() - this.getGap();
            tmp = layoutResult.getTextRect();
            tmp.x += this.getAfterCheckIconGap() - this.getGap();
        }
        this.calcXPositionsRTL(this.getViewRect().x + this.getViewRect().width, this.getLeadingGap(), this.getGap(), layoutResult.getArrowRect(), layoutResult.getAccRect());
        int textStartX = layoutResult.getTextRect().x - this.getViewRect().x;
        if (textStartX < this.getMinTextOffset()) {
            Rectangle textRect = layoutResult.getTextRect();
            textRect.x += this.getMinTextOffset() - textStartX;
        }
        this.alignRects(layoutResult, columnAlignment);
        layoutResult.setLabelRect(layoutResult.getTextRect().union(layoutResult.getIconRect()));
    }

    private void doRTLColumnLayout(MenuItemLayoutHelper.LayoutResult layoutResult, MenuItemLayoutHelper.ColumnAlignment columnAlignment) {
        layoutResult.getIconRect().width = this.getIconSize().getMaxWidth();
        layoutResult.getTextRect().width = this.getTextSize().getMaxWidth();
        this.calcXPositionsRTL(this.getViewRect().x + this.getViewRect().width, this.getLeadingGap(), this.getGap(), layoutResult.getCheckRect(), layoutResult.getIconRect(), layoutResult.getTextRect());
        if (layoutResult.getCheckRect().width > 0) {
            Rectangle tmp = layoutResult.getIconRect();
            tmp.x -= this.getAfterCheckIconGap() - this.getGap();
            tmp = layoutResult.getTextRect();
            tmp.x -= this.getAfterCheckIconGap() - this.getGap();
        }
        this.calcXPositionsLTR(this.getViewRect().x, this.getLeadingGap(), this.getGap(), layoutResult.getArrowRect(), layoutResult.getAccRect());
        int textStartX = this.getViewRect().x + this.getViewRect().width - (layoutResult.getTextRect().x + layoutResult.getTextRect().width);
        if (textStartX < this.getMinTextOffset()) {
            Rectangle textRect = layoutResult.getTextRect();
            textRect.x -= this.getMinTextOffset() - textStartX;
        }
        this.alignRects(layoutResult, columnAlignment);
        layoutResult.setLabelRect(layoutResult.getTextRect().union(layoutResult.getIconRect()));
    }

    private void alignRects(MenuItemLayoutHelper.LayoutResult layoutResult, MenuItemLayoutHelper.ColumnAlignment columnAlignment) {
        this.alignRect(layoutResult.getCheckRect(), columnAlignment.getCheckAlignment(), this.getCheckSize().getOrigWidth());
        this.alignRect(layoutResult.getIconRect(), columnAlignment.getIconAlignment(), this.getIconSize().getOrigWidth());
        this.alignRect(layoutResult.getTextRect(), columnAlignment.getTextAlignment(), this.getTextSize().getOrigWidth());
        this.alignRect(layoutResult.getAccRect(), columnAlignment.getAccAlignment(), this.getAccSize().getOrigWidth());
        this.alignRect(layoutResult.getArrowRect(), columnAlignment.getArrowAlignment(), this.getArrowSize().getOrigWidth());
    }

    private void alignRect(Rectangle rect, int horizontalAlignment, int width) {
        if (horizontalAlignment == 4) {
            rect.x = rect.x + rect.width - width;
        }
        rect.width = width;
    }

    private void calcXPositionsLTR(int startX, int leadingGap, int gap, Rectangle ... rects) {
        startX += leadingGap;
        for (int i2 = 0; i2 < rects.length; ++i2) {
            Rectangle rect = rects[i2];
            rect.x = startX;
            if (rect.width <= 0) continue;
            startX += rect.width + gap;
        }
    }

    private void calcXPositionsRTL(int startX, int leadingGap, int gap, Rectangle ... rects) {
        startX -= leadingGap;
        for (int i2 = 0; i2 < rects.length; ++i2) {
            Rectangle rect = rects[i2];
            rect.x = startX - rect.width;
            if (rect.width <= 0) continue;
            startX -= rect.width + gap;
        }
    }

    public static void applyInsets(Rectangle rect, Insets insets) {
        if (insets == null) {
            return;
        }
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.right + rect.x;
        rect.height -= insets.bottom + rect.y;
    }
}

