/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.DefaultLookupUI;
import com.android.tools.adtui.stdui.LookupUI;
import com.android.tools.adtui.stdui.Matcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010-\u001a\u00020\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00102\u001a\u000203H\u0016J\u0010\u00106\u001a\u0002052\u0006\u00102\u001a\u000203H\u0016J\b\u00107\u001a\u00020\u0005H\u0002J\u0018\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020:2\u0006\u00102\u001a\u000203H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R$\u0010*\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u0019\"\u0004\b,\u0010\u001b\u00a8\u0006<"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI;", "Lcom/android/tools/adtui/stdui/LookupUI;", "()V", "clickAction", "Lkotlin/Function0;", "", "getClickAction", "()Lkotlin/jvm/functions/Function0;", "setClickAction", "(Lkotlin/jvm/functions/Function0;)V", "list", "Lcom/intellij/ui/components/JBList;", "", "popup", "Ljavax/swing/JPopupMenu;", "popupSize", "Ljava/awt/Dimension;", "getPopupSize", "()Ljava/awt/Dimension;", "renderer", "Lcom/android/tools/adtui/stdui/DefaultLookupUI$LookupCellRenderer;", "value", "", "selectedIndex", "getSelectedIndex", "()I", "setSelectedIndex", "(I)V", "selectedValue", "getSelectedValue", "()Ljava/lang/String;", "setSelectedValue", "(Ljava/lang/String;)V", "", "semiFocused", "getSemiFocused", "()Z", "setSemiFocused", "(Z)V", "visible", "getVisible", "setVisible", "visibleRowCount", "getVisibleRowCount", "setVisibleRowCount", "createList", "listModel", "Ljavax/swing/ListModel;", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "editor", "Ljavax/swing/JComponent;", "editorBounds", "Ljava/awt/Rectangle;", "screenBounds", "updateElementHeight", "updateLocation", "location", "Ljava/awt/Point;", "LookupCellRenderer", "intellij.android.adt.ui"})
public final class DefaultLookupUI
implements LookupUI {
    @NotNull
    private final JPopupMenu popup = new JPopupMenu();
    @NotNull
    private final LookupCellRenderer renderer = new LookupCellRenderer();
    @NotNull
    private final JBList<String> list = new JBList();
    @NotNull
    private Function0<Unit> clickAction = clickAction.1.INSTANCE;

    @Override
    @NotNull
    public Function0<Unit> getClickAction() {
        return this.clickAction;
    }

    @Override
    public void setClickAction(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.clickAction = function0;
    }

    @Override
    public boolean getVisible() {
        return this.popup.isVisible();
    }

    @Override
    public void setVisible(boolean value) {
        this.popup.setVisible(value);
    }

    @Override
    public int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    @Override
    public void setVisibleRowCount(int value) {
        this.updateElementHeight();
        this.list.setVisibleRowCount(value);
    }

    @Override
    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int value) {
        this.list.setSelectedIndex(value);
        this.list.ensureIndexIsVisible(value);
    }

    @Override
    @Nullable
    public String getSelectedValue() {
        return (String)this.list.getSelectedValue();
    }

    @Override
    public void setSelectedValue(@Nullable String value) {
        this.list.setSelectedValue((Object)value, true);
    }

    @Override
    public boolean getSemiFocused() {
        return this.renderer.getSemiFocused();
    }

    @Override
    public void setSemiFocused(boolean value) {
        this.renderer.setSemiFocused(value);
    }

    @Override
    @NotNull
    public Dimension getPopupSize() {
        Dimension dimension = this.popup.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"popup.preferredSize");
        return dimension;
    }

    @Override
    public void createList(@NotNull ListModel<String> listModel, @NotNull Matcher matcher, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter(listModel, (String)"listModel");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (int)20, (int)31);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(list, V\u2026RIZONTAL_SCROLLBAR_NEVER)");
        JScrollPane scrollPane = jScrollPane;
        this.popup.add(scrollPane);
        this.renderer.setMatcher(matcher);
        this.list.setModel(listModel);
        this.list.setFocusable(false);
        this.list.setCellRenderer((ListCellRenderer)((Object)this.renderer));
        this.list.setSelectionMode(0);
        this.list.setBackground((Color)this.renderer.getBackgroundColor());
        this.list.getAccessibleContext().setAccessibleName("Code Completion");
        this.list.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ DefaultLookupUI this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getClickAction().invoke();
            }
        });
        AccessibleContextUtil.setParent((Component)((Component)this.list), (Component)editor);
    }

    private final void updateElementHeight() {
        ListModel model2 = this.list.getModel();
        this.list.setFixedCellHeight(model2.getSize() > 0 ? this.renderer.getListCellRendererComponent((JList)((JList)this.list), model2.getElementAt((int)0), (int)0, (boolean)false, (boolean)false).getPreferredSize().height : 16);
    }

    @Override
    public void updateLocation(@NotNull Point location, @NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Window window = SwingUtilities.getWindowAncestor(this.popup);
        if (this.getVisible() && window != null) {
            window.setSize(window.getPreferredSize());
            if (!Intrinsics.areEqual((Object)window.getLocation(), (Object)location)) {
                window.setLocation(location);
            }
        } else {
            this.popup.setSize(this.popup.getPreferredSize());
            this.popup.setLocation(location);
        }
    }

    @Override
    @NotNull
    public Rectangle screenBounds(@NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = editor.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return new Rectangle(new Point(0, 0), toolkit.getScreenSize());
        }
        GraphicsConfiguration configuration = graphicsConfiguration;
        Rectangle screenBounds = configuration.getBounds();
        Insets screenInsets = toolkit.getScreenInsets(configuration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Intrinsics.checkNotNullExpressionValue((Object)screenBounds, (String)"screenBounds");
        return screenBounds;
    }

    @Override
    @NotNull
    public Rectangle editorBounds(@NotNull JComponent editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Point topLeft = new Point();
        SwingUtilities.convertPointToScreen(topLeft, editor);
        return new Rectangle(topLeft.x, topLeft.y, editor.getWidth(), editor.getHeight());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI$LookupCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "()V", "backgroundColor", "Lcom/intellij/ui/JBColor;", "getBackgroundColor", "()Lcom/intellij/ui/JBColor;", "filterAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "filterForegroundColor", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "getMatcher", "()Lcom/android/tools/adtui/stdui/Matcher;", "setMatcher", "(Lcom/android/tools/adtui/stdui/Matcher;)V", "selectedAttributes", "selectedFocusedBackgroundColor", "selectedForegroundColor", "selectedNonFocusedBackgroundColor", "semiFocused", "", "getSemiFocused", "()Z", "setSemiFocused", "(Z)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "hasFocus", "intellij.android.adt.ui"})
    public static final class LookupCellRenderer
    extends ColoredListCellRenderer<String> {
        @NotNull
        private final JBColor selectedFocusedBackgroundColor = new JBColor(21156, 21156);
        @NotNull
        private final JBColor selectedNonFocusedBackgroundColor = new JBColor(7245474, 0x55585A);
        @NotNull
        private final JBColor selectedForegroundColor = new JBColor(0xFFFFFF, 0xFFFFFF);
        @NotNull
        private final JBColor filterForegroundColor = new JBColor(0xB000B0, 13728470);
        @NotNull
        private final SimpleTextAttributes filterAttributes = new SimpleTextAttributes(0, (Color)this.filterForegroundColor);
        @NotNull
        private final SimpleTextAttributes selectedAttributes = new SimpleTextAttributes(0, (Color)this.selectedForegroundColor);
        @NotNull
        private final JBColor backgroundColor = new JBColor(15463678, 3224629);
        private boolean semiFocused;
        @Nullable
        private Matcher matcher;

        @NotNull
        public final JBColor getBackgroundColor() {
            return this.backgroundColor;
        }

        public final boolean getSemiFocused() {
            return this.semiFocused;
        }

        public final void setSemiFocused(boolean bl) {
            this.semiFocused = bl;
        }

        @Nullable
        public final Matcher getMatcher() {
            return this.matcher;
        }

        public final void setMatcher(@Nullable Matcher matcher) {
            this.matcher = matcher;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NotNull String value, int index, boolean selected, boolean hasFocus) {
            List<TextRange> ranges;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.setBackground(selected && this.semiFocused ? (Color)this.selectedFocusedBackgroundColor : (selected ? (Color)this.selectedNonFocusedBackgroundColor : (Color)this.backgroundColor));
            SimpleTextAttributes foregroundAttributes = selected ? this.selectedAttributes : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Matcher matcher = this.matcher;
            List<Object> list2 = ranges = matcher != null ? matcher.matchingFragments(value) : null;
            if (ranges != null) {
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)((SimpleColoredComponent)this), (String)value, (Iterable)ranges, (SimpleTextAttributes)foregroundAttributes, (SimpleTextAttributes)this.filterAttributes);
            } else {
                this.append(value, foregroundAttributes);
            }
        }
    }
}

