/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.adtui.stdui.Lookup;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.BooleanFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001eH\u0014J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0014J\b\u0010#\u001a\u00020\u0012H\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0088\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/adtui/stdui/CommonTextField;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/intellij/ui/components/JBTextField;", "editorModel", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;)V", "_lookup", "Lcom/android/tools/adtui/stdui/Lookup;", "documentChangeFromSetText", "", "getEditorModel", "()Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "lookup", "getLookup", "()Lcom/android/tools/adtui/stdui/Lookup;", "updatingFromModel", "backTab", "", "enterInLookup", "escapeInLookup", "getComponentWithErrorBorder", "Ljavax/swing/JComponent;", "isLookupEnabled", "paintComponent", "g", "Ljava/awt/Graphics;", "setFromModel", "setText", "text", "", "showLookupCompletions", "forText", "tab", "updateFromModel", "updateOutline", "intellij.android.adt.ui"})
public class CommonTextField<M extends CommonTextFieldModel>
extends JBTextField {
    @NotNull
    private final M editorModel;
    @Nullable
    private Lookup<? extends M> _lookup;
    private boolean updatingFromModel;
    private boolean documentChangeFromSetText;

    public CommonTextField(@NotNull M editorModel) {
        Intrinsics.checkNotNullParameter(editorModel, (String)"editorModel");
        this.editorModel = editorModel;
        if (!Intrinsics.areEqual(this.editorModel.getEditingSupport().getCompletion(), EditingSupportKt.EDITOR_NO_COMPLETIONS)) {
            final Lookup myLookup = new Lookup(this, null, 2, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.enterInLookup();
                }
            }, KeyStrokes.INSTANCE.getENTER(), "enter", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.escapeInLookup();
                }
            }, KeyStrokes.INSTANCE.getESCAPE(), "escape", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.tab();
                }
            }, KeyStrokes.INSTANCE.getTAB(), "tab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.backTab();
                }
            }, KeyStrokes.INSTANCE.getBACKTAB(), "backTab", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    String string = this.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    this.showLookupCompletions(string);
                }
            }, KeyStrokes.INSTANCE.getCTRL_SPACE(), "showCompletions", null, 0, 24, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectNext();
                }
            }, KeyStrokes.INSTANCE.getDOWN(), "selectNext", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectPrevious();
                }
            }, KeyStrokes.INSTANCE.getUP(), "selectPrevious", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectNextPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_DOWN(), "selectNextPage", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectPreviousPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_UP(), "selectPreviousPage", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectFirst();
                }
            }, KeyStrokes.INSTANCE.getCMD_HOME(), "selectFirst", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            KeyBindingKt.registerActionKey$default((JComponent)((Object)this), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    myLookup.selectLast();
                }
            }, KeyStrokes.INSTANCE.getCMD_END(), "selectLast", (Function0)new Function0<Boolean>(){

                @NotNull
                public final Boolean invoke() {
                    return myLookup.getEnabled();
                }
            }, 0, 16, null);
            this.setFocusTraversalKeysEnabled(false);
            super.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(@NotNull FocusEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    myLookup.close();
                }
            });
            this._lookup = myLookup;
        }
        this.putClientProperty("StatusVisibleFunction", new BooleanFunction(){

            public final boolean fun(JTextComponent it) {
                String string = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                return ((CharSequence)string).length() == 0;
            }
        });
        this.setFocusable(true);
        this.setFromModel();
        this.editorModel.addListener(new ValueChangedListener(){

            @Override
            public final void valueChanged() {
                this.updateFromModel();
            }
        });
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                block3: {
                    block4: {
                        String newText;
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            if (updatingFromModel) break block3;
                            newText = this.getText();
                            Object m = this.getEditorModel();
                            Intrinsics.checkNotNullExpressionValue((Object)newText, (String)"newText");
                            m.setText(newText);
                            if (documentChangeFromSetText) break block4;
                            if (((CharSequence)newText).length() > 0) break block5;
                            Lookup lookup = this.getLookup();
                            boolean bl = lookup != null ? lookup.isVisible() : false;
                            if (!bl) break block4;
                        }
                        this.showLookupCompletions(newText);
                    }
                    this.updateOutline();
                }
            }
        });
    }

    @NotNull
    public final M getEditorModel() {
        return this.editorModel;
    }

    @Nullable
    public final Lookup<M> getLookup() {
        return this._lookup;
    }

    protected void showLookupCompletions(@NotNull String forText) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
            Lookup<M> lookup = this.getLookup();
            if (lookup == null) break block0;
            lookup.showLookup(forText);
        }
    }

    protected void updateFromModel() {
        this.setFromModel();
    }

    public final boolean enterInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.enter() : false;
    }

    public final boolean escapeInLookup() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.escape() : false;
    }

    public final boolean isLookupEnabled() {
        Lookup<M> lookup = this._lookup;
        return lookup != null ? lookup.getEnabled() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setFromModel() {
        this.updatingFromModel = true;
        try {
            this.setText(this.editorModel.getValue());
            this.setEnabled(this.editorModel.getEnabled());
            this.setEditable(this.editorModel.getEditable());
            this.getEmptyText().setText(this.editorModel.getPlaceHolderValue());
            this.updateOutline();
        }
        finally {
            this.updatingFromModel = false;
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        boolean selectionVisible = this.getCaret().isSelectionVisible();
        this.getCaret().setSelectionVisible(true);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        super.paintComponent((Graphics)g2);
        this.getCaret().setSelectionVisible(selectionVisible);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@Nullable String text) {
        this.documentChangeFromSetText = true;
        try {
            if (!StringsKt.equals$default((String)text, (String)super.getText(), (boolean)false, (int)2, null)) {
                super.setText(text);
            }
            UIUtil.resetUndoRedoActions((JTextComponent)((JTextComponent)((Object)this)));
        }
        finally {
            this.documentChangeFromSetText = false;
        }
    }

    private final void tab() {
        this.enterInLookup();
        this.transferFocus();
    }

    private final void backTab() {
        this.enterInLookup();
        this.transferFocusBackward();
    }

    private final void updateOutline() {
        EditingErrorCategory code;
        String newOutline;
        JComponent jComponent = this.getComponentWithErrorBorder();
        if (jComponent == null) {
            return;
        }
        JComponent component = jComponent;
        Object current = component.getClientProperty("JComponent.outline");
        if (!Intrinsics.areEqual((Object)current, (Object)(newOutline = (code = (EditingErrorCategory)((Object)((Pair)this.editorModel.getEditingSupport().getValidation().invoke((Object)this.getText())).component1())).getOutline()))) {
            component.putClientProperty("JComponent.outline", newOutline);
            component.repaint();
        }
    }

    private final JComponent getComponentWithErrorBorder() {
        if (this.getBorder() instanceof ErrorBorderCapable) {
            return (JComponent)((Object)this);
        }
        Container container = this.getParent();
        JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
        if (jComponent == null) {
            return null;
        }
        JComponent parent = jComponent;
        if (parent.getBorder() instanceof ErrorBorderCapable) {
            return parent;
        }
        return null;
    }
}

