/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class Range
extends AspectModel<Aspect> {
    private double myMin;
    private double myMax;

    public Range(double min, double max) {
        this.myMin = min;
        this.myMax = max;
    }

    public Range(Range other) {
        this.myMin = other.myMin;
        this.myMax = other.myMax;
    }

    public Range() {
        this.clear();
    }

    public void setMin(double min) {
        this.set(min, this.myMax);
    }

    public void setMax(double max) {
        this.set(this.myMin, max);
    }

    public void set(double min, double max) {
        if (Double.compare(this.myMin, min) != 0 || Double.compare(this.myMax, max) != 0) {
            this.myMin = min;
            this.myMax = max;
            this.changed(Aspect.RANGE);
        }
    }

    public void set(Range other) {
        this.set(other.getMin(), other.getMax());
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public double getLength() {
        return Math.abs(this.getMax() - this.getMin());
    }

    public boolean isPoint() {
        return Double.compare(this.getMin(), this.getMax()) == 0;
    }

    public boolean isEmpty() {
        return this.myMin > this.myMax;
    }

    public boolean contains(double value) {
        return this.myMin <= value && value <= this.myMax;
    }

    public void clear() {
        this.set(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public double clamp(double value) {
        return Math.min(Math.max(this.getMin(), value), this.getMax());
    }

    public void shift(double delta) {
        this.set(this.getMin() + delta, this.getMax() + delta);
    }

    public List<Range> subtract(Range range) {
        LinkedList<Range> ret = new LinkedList<Range>();
        Range intersection = this.getIntersection(range);
        if (intersection.isEmpty()) {
            ret.add(this);
        } else {
            Range left = new Range(this.myMin, intersection.getMin());
            Range right = new Range(intersection.getMax(), this.myMax);
            if (!left.isPoint()) {
                ret.add(left);
            }
            if (!right.isPoint()) {
                ret.add(right);
            }
        }
        return ret;
    }

    public Range getIntersection(Range range) {
        if (this.isEmpty() || range.isEmpty() || range.getMin() > this.getMax() || range.getMax() < this.getMin()) {
            return new Range();
        }
        return new Range(Math.max(this.getMin(), range.getMin()), Math.min(this.getMax(), range.getMax()));
    }

    public boolean intersectsWith(@NotNull Range range) {
        return this.intersectsWith(range.getMin(), range.getMax());
    }

    public boolean intersectsWith(double min, double max) {
        return Math.max(this.getMin(), min) <= Math.min(this.getMax(), max);
    }

    public double getIntersectionLength(@NotNull Range range) {
        return this.getIntersectionLength(range.getMin(), range.getMax());
    }

    public double getIntersectionLength(double min, double max) {
        double intersectionMin = Math.max(this.myMin, min);
        double intersectionMax = Math.min(this.myMax, max);
        return Math.max(0.0, intersectionMax - intersectionMin);
    }

    public void expand(double min, double max) {
        this.set(Math.min(min, this.myMin), Math.max(max, this.myMax));
    }

    public void adjustToContain(double min, double max) {
        if (min < this.myMin) {
            this.set(min, Math.max(max, min + this.getLength()));
        } else if (max > this.myMax) {
            this.set(Math.min(min, max - this.getLength()), max);
        }
    }

    public String toString() {
        return !this.isEmpty() ? String.format("[%s..%s]", this.myMin, this.myMax) : "[]";
    }

    public boolean isSameAs(@NotNull Range otherRange) {
        return this.isEmpty() && otherRange.isEmpty() || Double.compare(otherRange.myMin, this.myMin) == 0 && Double.compare(otherRange.myMax, this.myMax) == 0;
    }

    public static enum Aspect {
        RANGE;

    }
}

